/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.lzh;

import java.io.FilterOutputStream;
import java.io.IOException;
import jp.sourceforge.armadillo.lzh.LzssEncoderWritable;

public final class LzssOutputStream
extends FilterOutputStream {
    private final int dictionarySize;
    private final int matchSize;
    private final int threshold;
    private boolean closed = false;
    private LzssEncoderWritable output;
    private byte[] buffer;
    private int index;
    private int limit;

    public LzssOutputStream(LzssEncoderWritable lzssEncoderWritable, int n, int n2, int n3) {
        super(null);
        this.output = lzssEncoderWritable;
        this.dictionarySize = n;
        this.matchSize = n2;
        this.threshold = n3;
        this.buffer = new byte[n];
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream already closed");
        }
    }

    public void write(int n) throws IOException {
        this.ensureOpen();
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        int n3 = n2;
        int n4 = n;
        while (n3 > 0) {
            int n5 = this.dictionarySize - this.limit;
            int n6 = n5 < n3 ? n5 : n3;
            System.arraycopy(byArray, n4, this.buffer, this.limit, n6);
            n3 -= n6;
            n4 += n6;
            this.limit += n6;
            if (n6 != n5) continue;
            this.encode();
        }
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.encode();
        this.output.flush();
    }

    private void encode() throws IOException {
        while (this.index < this.limit) {
            int n;
            int n2 = -1;
            int n3 = 0;
            for (n = this.index - 1; n >= 0; --n) {
                int n4;
                if (n + n3 >= this.limit || this.index + n3 >= this.limit || this.buffer[n] != this.buffer[this.index] || this.buffer[n + n3] != this.buffer[this.index + n3]) continue;
                for (n4 = 0; n4 < this.matchSize && this.index + n4 < this.limit && this.buffer[n + n4] == this.buffer[this.index + n4]; ++n4) {
                }
                if (n4 <= n3) continue;
                n2 = n;
                n3 = n4;
            }
            int n5 = n = n3 >= this.threshold ? this.index - n2 : -1;
            if (n >= 0) {
                this.output.writeMatched(n, n3);
                this.index += n3;
                continue;
            }
            this.output.write(this.buffer[this.index++] & 0xFF);
        }
        if (this.limit > this.dictionarySize - this.matchSize) {
            this.index -= this.matchSize;
            this.limit -= this.matchSize;
            System.arraycopy(this.buffer, this.matchSize, this.buffer, 0, this.limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.ensureOpen();
        try {
            this.flush();
        }
        finally {
            this.buffer = null;
            this.output.close();
            this.output = null;
        }
    }
}

