/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.tar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import jp.sourceforge.armadillo.tar.TarEntry;

public final class TarHeader {
    private static final int BLOCK_SIZE = 512;
    private byte[] bytes = new byte[512];
    private int position = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TarEntry read(InputStream inputStream) throws IOException {
        this.reset();
        int n = TarHeader.read(inputStream, this.bytes);
        if (n != 512) {
            throw new IOException("bad header: size=" + n);
        }
        if (this.bytes[0] == 0 && this.isEmptyBlock()) {
            if (inputStream.read(this.bytes) == 512 && this.isEmptyBlock()) {
                return null;
            }
            throw new IOException("bad end-of-archive");
        }
        try {
            TarEntry tarEntry = new TarEntry();
            this.clipNameField(tarEntry, 100);
            tarEntry.mode = this.clipAsInt(8);
            tarEntry.uid = this.clipAsInt(8);
            tarEntry.gid = this.clipAsInt(8);
            tarEntry.size = this.clipAsLong(12);
            tarEntry.timeT = (int)(this.clipAsLong(12) & 0xFFFFFFFFL);
            tarEntry.chksum = this.clipAsInt(8);
            tarEntry.typeFlag = (char)this.bytes[this.position++];
            tarEntry.linkName = this.clip(100);
            tarEntry.magic = this.clip(6);
            tarEntry.version = this.clip(2);
            tarEntry.uname = this.clip(32);
            tarEntry.gname = this.clip(32);
            tarEntry.devmajor = this.clip(8);
            tarEntry.devminor = this.clip(8);
            tarEntry.prefix = this.clip(155);
            if (tarEntry.getTypeFlag() == 'L') {
                n = TarHeader.read(inputStream, this.bytes);
                if (!$assertionsDisabled && n != 512) {
                    throw new AssertionError();
                }
                this.position = 0;
                TarEntry tarEntry2 = new TarEntry();
                this.clipNameField(tarEntry2, 512);
                tarEntry = this.read(inputStream);
                tarEntry.name = tarEntry2.name;
                tarEntry.nameAsBytes = tarEntry2.nameAsBytes;
            }
            return tarEntry;
        }
        catch (RuntimeException runtimeException) {
            IOException iOException = new IOException("bad header at " + this.position);
            iOException.initCause(runtimeException);
            throw iOException;
        }
    }

    private static int read(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3 = 0;
        for (n = 0; n < 512 && (n2 = inputStream.read(byArray, n3, 512 - n)) > 0; n += n2) {
            n3 += n2;
        }
        return n;
    }

    public void write(OutputStream outputStream, TarEntry tarEntry) throws IOException {
        try {
            this.reset();
            if (tarEntry.nameAsBytes == null) {
                this.patch(tarEntry.name, 100);
            } else {
                this.patch(tarEntry.nameAsBytes, 100);
            }
            this.patch(tarEntry.mode, 8);
            this.patch(tarEntry.uid, 8);
            this.patch(tarEntry.gid, 8);
            this.patch(tarEntry.size, 12);
            this.patch(tarEntry.timeT, 12);
            this.patch("        ", 8);
            this.patch(String.valueOf(tarEntry.typeFlag), 1);
            this.patch(tarEntry.linkName, 100);
            this.patch(tarEntry.magic, 6);
            this.patch(tarEntry.version, 2);
            this.patch(tarEntry.uname, 32);
            this.patch(tarEntry.gname, 32);
            this.patch(tarEntry.devmajor, 8);
            this.patch(tarEntry.devminor, 8);
            this.patch(tarEntry.prefix, 155);
            int n = 0;
            for (int i = 0; i < this.bytes.length; ++i) {
                n += this.bytes[i] & 0xFF;
            }
            this.position = 148;
            this.patch(n, 6);
            tarEntry.setChksum(n);
            outputStream.write(this.bytes);
        }
        catch (RuntimeException runtimeException) {
            IOException iOException = new IOException("bad header at " + this.position);
            iOException.initCause(runtimeException);
            throw iOException;
        }
    }

    public void writeEndOfArchive(OutputStream outputStream) throws IOException {
        this.reset();
        outputStream.write(this.bytes);
        outputStream.write(this.bytes);
        outputStream.flush();
    }

    public void reset() {
        this.position = 0;
        Arrays.fill(this.bytes, (byte)0);
    }

    private void clipNameField(TarEntry tarEntry, int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.bytes, this.position, byArray, 0, n);
        tarEntry.name = this.clip(n);
        tarEntry.nameAsBytes = byArray;
    }

    private String clip(int n) {
        if (!$assertionsDisabled && n > 512 - this.position) {
            throw new AssertionError();
        }
        int n2 = this.position;
        this.position += n;
        int n3 = 0;
        for (int i = 0; i < n && this.bytes[n2 + i] != 0; ++i) {
            ++n3;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n3; ++i) {
            byte by = this.bytes[n2 + i];
            if ((by & 0x80) == 128) {
                stringBuffer.append('\\');
                stringBuffer.append(Integer.toOctalString(by & 0xFF));
                continue;
            }
            stringBuffer.append((char)by);
        }
        return stringBuffer.toString();
    }

    private int clipAsInt(int n) {
        return Integer.parseInt(this.clipAsNumberString(n), 8);
    }

    private long clipAsLong(int n) {
        return Long.parseLong(this.clipAsNumberString(n), 8);
    }

    private String clipAsNumberString(int n) {
        byte by;
        int n2;
        if (!$assertionsDisabled && n > 512 - this.position) {
            throw new AssertionError();
        }
        int n3 = this.position;
        this.position += n;
        for (n2 = 0; n2 < n && (by = this.bytes[n3 + n2]) != 0; ++n2) {
            if (!($assertionsDisabled || by >= 48 && by <= 57)) {
                throw new AssertionError();
            }
        }
        String string = new String(this.bytes, n3, n2);
        return string.trim();
    }

    private int patch(String string, int n) {
        int n2 = this.position;
        this.position += n;
        byte[] byArray = string == null ? new byte[]{} : string.getBytes();
        return this.patch(byArray, n2);
    }

    private int patch(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.bytes, n, byArray.length);
        return byArray.length;
    }

    private int patch(int n, int n2) {
        String string = this.padZero(Integer.toOctalString(n), n2 - 1);
        return this.patch(string + '\u0000', n2);
    }

    private int patch(long l, int n) {
        String string = this.padZero(Long.toOctalString(l), n - 1);
        return this.patch(string + '\u0000', n);
    }

    private String padZero(String string, int n) {
        int n2;
        int n3 = string.length();
        if (n3 >= n) {
            return string;
        }
        char[] cArray = new char[n];
        int n4 = n - n3;
        for (n2 = 0; n2 < n4; ++n2) {
            cArray[n2] = 48;
        }
        for (n2 = n4; n2 < n; ++n2) {
            cArray[n2] = string.charAt(n2 - n4);
        }
        return String.valueOf(cArray);
    }

    private boolean isEmptyBlock() {
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == 0) continue;
            return false;
        }
        return true;
    }

    static long getSkipSize(long l) {
        if (l == 0L || l == 512L || l % 512L == 0L) {
            return 0L;
        }
        return 512L - (l > 512L ? l % 512L : l);
    }

    static {
        $assertionsDisabled = !TarHeader.class.desiredAssertionStatus();
    }
}

