/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.zip;

public final class ZipEntry {
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    String name;
    byte[] nameAsBytes;
    short version;
    short option;
    int method;
    int fTime;
    long crc;
    long compressedSize;
    long size;
    int position;

    public ZipEntry() {
        this("");
    }

    public ZipEntry(String string) {
        this.name = string;
        this.version = (short)10;
        this.option = 0;
        this.method = 8;
        this.fTime = 0;
        this.crc = -1L;
        this.compressedSize = -1L;
        this.size = -1L;
    }

    public ZipEntry(ZipEntry zipEntry) {
        this.name = zipEntry.name;
        this.version = zipEntry.version;
        this.option = zipEntry.option;
        this.method = zipEntry.method;
        this.fTime = zipEntry.fTime;
        this.crc = zipEntry.crc;
        this.compressedSize = zipEntry.compressedSize;
        this.size = zipEntry.size;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public boolean hasEXT() {
        return (this.option & 8) == 8;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = string;
    }

    public byte[] getNameAsBytes() {
        return this.nameAsBytes;
    }

    public void setNameAsBytes(byte[] byArray) {
        this.nameAsBytes = byArray;
    }

    public short getVersion() {
        return this.version;
    }

    public void setVersion(short s) {
        this.version = s;
    }

    public short getOption() {
        return this.option;
    }

    public void setOption(short s) {
        this.option = s;
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int n) {
        this.method = n;
    }

    public int getFTime() {
        return this.fTime;
    }

    public void setFTime(int n) {
        this.fTime = n;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setCrc(long l) {
        this.crc = l;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(long l) {
        this.compressedSize = l;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l) {
        this.size = l;
    }
}

