/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import jp.sourceforge.armadillo.io.ArchiveInputStream;
import jp.sourceforge.armadillo.zip.RewindableInputStream;
import jp.sourceforge.armadillo.zip.ZipEntry;
import jp.sourceforge.armadillo.zip.ZipHeader;

public final class ZipInputStream
extends ArchiveInputStream {
    private ZipHeader header;
    private Inflater inflater;
    private ZipEntry nextEntry;
    private RandomAccessFile raf;
    private long cenOffset;
    private boolean randomAccess;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZipInputStream(InputStream inputStream) {
        super(new RewindableInputStream(inputStream, 4096));
        this.randomAccess = false;
        this.header = new ZipHeader(null);
        this.inflater = new Inflater(true);
    }

    public ZipInputStream(File file) throws IOException {
        this(file, null);
    }

    public ZipInputStream(File file, String string) throws IOException {
        super(null);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        this.in = new RewindableInputStream(Channels.newInputStream(randomAccessFile.getChannel()), 4096);
        this.header = new ZipHeader(string);
        this.inflater = new Inflater(true);
        this.cenOffset = 0L;
        randomAccessFile.seek(randomAccessFile.length() - 22L);
        ZipEntry zipEntry = this.header.readEND(this.in);
        if (zipEntry == null) {
            randomAccessFile.seek(0L);
            this.randomAccess = false;
        } else {
            this.raf = randomAccessFile;
            this.cenOffset = zipEntry.position;
            this.randomAccess = true;
        }
    }

    public ZipEntry getNextEntry() throws IOException {
        int n;
        ZipEntry zipEntry;
        this.ensureOpen();
        if (this.nextEntry != null) {
            this.closeEntry();
        }
        if (this.randomAccess) {
            this.raf.seek(this.cenOffset);
            zipEntry = this.header.readCEN(this.in);
            this.cenOffset = this.raf.getFilePointer();
        } else {
            zipEntry = this.header.read(this.in);
        }
        if (zipEntry == null) {
            return null;
        }
        if (this.randomAccess) {
            this.raf.seek(zipEntry.position);
            this.header.read(this.in);
        }
        if ((n = zipEntry.method) == 8) {
            this.frontStream = new InflaterInputStream(this.in, this.inflater, 512);
        } else if (n == 0) {
            this.frontStream = this.in;
        } else {
            throw new IOException("invalid method: " + n);
        }
        this.remaining = zipEntry.getSize();
        this.nextEntry = zipEntry;
        return this.nextEntry;
    }

    public void closeEntry() throws IOException {
        long l;
        this.ensureOpen();
        if (!this.randomAccess && !this.nextEntry.isDirectory()) {
            int n;
            if (this.remaining > 0L && this.nextEntry.getCompressedSize() < this.nextEntry.getSize()) {
                while (this.remaining > 0L) {
                    this.skip(this.remaining);
                }
            }
            if ((n = this.inflater.getRemaining()) > 0) {
                ((RewindableInputStream)this.in).rewind(n);
            }
        }
        if (this.randomAccess) {
            this.remaining = 0L;
        } else if (this.nextEntry.hasEXT()) {
            ZipEntry zipEntry = this.header.readEXT(this.in);
            if (zipEntry != null) {
                this.nextEntry.crc = zipEntry.crc;
                this.nextEntry.compressedSize = zipEntry.compressedSize;
                this.nextEntry.size = zipEntry.size;
            }
            this.remaining = 0L;
        } else if (!this.nextEntry.isDirectory() && (l = this.nextEntry.getCompressedSize() - (long)this.inflater.getTotalIn()) != 0L) {
            if (l > 0L) {
                this.in.skip(l);
            } else {
                throw new IOException("unexpected state");
            }
        }
        if (!$assertionsDisabled && this.remaining != 0L) {
            throw new AssertionError((Object)("remaining: " + this.remaining));
        }
        this.nextEntry = null;
        this.inflater.reset();
        this.frontStream = this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.randomAccess) {
                this.raf.close();
            }
        }
        finally {
            this.header = null;
            this.inflater = null;
            this.nextEntry = null;
            super.close();
        }
    }

    static {
        $assertionsDisabled = !ZipInputStream.class.desiredAssertionStatus();
    }
}

