package jp.sourceforge.armadillo;

import java.io.*;
import java.nio.charset.*;

/**
 * GR[fBO@\B
 */
abstract class CharacterEncoding {

    protected boolean usesEncoding;

    private String charsetName;

    /**
     * ̃GR[fBOɎgp镶Zbgݒ肷B
     * @param charsetName Zbg
     * @return T|[gĂȂZbgw肵ꍇ <code>false</code>
     *         łȂ <code>true</code>
     */
    public boolean setCharsetName(String charsetName) {
        if (charsetName == null || charsetName.trim().length() == 0) {
            this.usesEncoding = false;
            this.charsetName = charsetName;
        } else {
            if (!Charset.isSupported(charsetName)) {
                return false;
            }
            this.usesEncoding = true;
            this.charsetName = charsetName;
        }
        return true;
    }

    /**
     * GR[hB
     * @param s GR[h镶
     * @return GR[hꂽoCg
     */
    byte[] encode(String s) {
        if (usesEncoding) {
            try {
                return s.getBytes(s);
            } catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return s.getBytes();
    }

    /**
     * fR[hB
     * @param bytes fR[hoCg
     * @return fR[hꂽ
     */
    String decode(byte[] bytes) {
        if (usesEncoding) {
            try {
                return new String(bytes, charsetName);
            } catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return new String(bytes);
    }

}
