package jp.sourceforge.armadillo;

import java.io.*;
import java.util.zip.*;

/**
 * t@CA[JCuB
 */
public final class FileArchiver implements Archiver {

    private Archiver archiver;

    /**
     * FileArchiver̐B
     * @param dst o͐t@C
     * @throws IOException o̓G[ꍇ 
     */
    public FileArchiver(File dst) throws IOException {
        this(dst, ArchiveType.getType(dst));
    }

    /* @see jp.sourceforge.armadillo.Archiver#setCharsetName(java.lang.String) */
    public boolean setCharsetName(String charsetName) {
        return archiver.setCharsetName(charsetName);
    }

    /**
     * FileArchiver̐B
     * @param dst o͐t@C
     * @param type A[JCu^Cv
     * @throws IOException o̓G[ꍇ 
     */
    public FileArchiver(File dst, ArchiveType type) throws IOException {
        this.archiver = getArchiver(dst, type);
    }

    /* @see jp.sourceforge.armadillo.Archiver#addEntry(jp.sourceforge.armadillo.ArchiveEntry, java.io.File) */
    public void addEntry(ArchiveEntry ae, File file) throws IOException {
        archiver.addEntry(ae, file);
    }

    /* @see jp.sourceforge.armadillo.Archiver#addEntry(jp.sourceforge.armadillo.ArchiveEntry,
                                                       java.io.InputStream, long) */
    public void addEntry(ArchiveEntry ae, InputStream is, long length) throws IOException {
        archiver.addEntry(ae, is, length);
    }

    /**
     * Archiver̎擾B
     * @param dst (k)Ƀt@C
     * @return Archiver
     * @throws IOException o̓G[ꍇ
     */
    public static Archiver getArchiver(File dst) throws IOException {
        return getArchiver(dst, ArchiveType.getType(dst));
    }

    /**
     * Archiver̎擾B
     * @param dst (k)Ƀt@C
     * @param type Ƀ^Cv
     * @return Archiver
     * @throws IOException o̓G[ꍇ
     */
    public static Archiver getArchiver(File dst, ArchiveType type) throws IOException {
        if (type == ArchiveType.TAR) {
            return new TarArchiver(dst);
        } else if (type == ArchiveType.TGZ) {
            return new TarArchiver(new GZIPOutputStream(new FileOutputStream(dst)));
        } else if (type == ArchiveType.ZIP) {
            return new ZipArchiver(new FileOutputStream(dst));
        } else if (type == ArchiveType.LZH) {
            return new LzhArchiver(dst);
        } else {
            throw new IllegalStateException(String.valueOf(type));
        }
    }

    /**
     * IB
     * @throws IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        archiver.close();
    }

}
