package jp.sourceforge.armadillo;

import java.io.*;
import java.util.*;
import java.util.zip.*;

/**
 * A[JCut@CWJB
 */
public final class FileExpander implements Expander {

    private Expander expander;

    /**
     * FileExpander̐B
     * @param src WJt@C
     * @throws IOException o̓G[ꍇ
     */
    public FileExpander(File src) throws IOException {
        this(src, ArchiveType.getType(src));
    }

    /**
     * FileExpander̐B
     * @param src WJt@C
     * @param type Ƀ^Cv
     * @throws IOException o̓G[ꍇ
     */
    public FileExpander(File src, ArchiveType type) throws IOException {
        this.expander = getExpander(src, type);
    }

    /**
     * Gg񂷂Ce[^ԂB
     * @return Iterator
     */
    public Iterator iterator() {
        return new Iterator() {

            private ArchiveEntry entry;

            public boolean hasNext() {
                try {
                    entry = nextEntry();
                    return !entry.isNull();
                } catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            public Object next() {
                return entry;
            }

            public void remove() {
                throw new UnsupportedOperationException("Iterator#remove");
            }

        };
    }

    /* @see jp.sourceforge.armadillo.Expander#setCharsetName(java.lang.String) */
    public boolean setCharsetName(String charsetName) {
        return expander.setCharsetName(charsetName);
    }

    /*
     * @see jp.sourceforge.armadillo.Expander#nextEntry()
     */
    public ArchiveEntry nextEntry() throws IOException {
        return expander.nextEntry();
    }

    /*
     * @see jp.sourceforge.armadillo.Expander#expand(java.io.OutputStream)
     */
    public long expand(OutputStream os) throws IOException {
        return expander.expand(os);
    }

    /**
     * Expander̎擾B
     * @param src (WJ)Ƀt@C
     * @return Expander
     * @throws IOException o̓G[ꍇ 
     */
    public static Expander getExpander(File src) throws IOException {
        return getExpander(src, ArchiveType.getType(src));
    }

    /**
     * Expander̎擾B
     * @param src (WJ)Ƀt@C
     * @param type Ƀ^Cv
     * @return Expander
     * @throws IOException o̓G[ꍇ 
     */
    public static Expander getExpander(File src, ArchiveType type) throws IOException {
        if (type == ArchiveType.TAR) {
            return new TarExpander(new FileInputStream(src));
        } else if (type == ArchiveType.TGZ) {
            return new TarExpander(new GZIPInputStream(new FileInputStream(src)));
        } else if (type == ArchiveType.ZIP) {
            return new ZipExpander(src);
        } else if (type == ArchiveType.LZH) {
            return new LzhExpander(new FileInputStream(src));
        } else {
            throw new IllegalStateException("File: " + src + ", ArchiverType: " + type);
        }
    }

    /**
     * IB
     * @throws IOException o̓G[ꍇ 
     */
    public void close() throws IOException {
        expander.close();
    }

}
