package jp.sourceforge.armadillo;

import java.io.*;

import jp.sourceforge.armadillo.Utilities.*;
import jp.sourceforge.armadillo.io.*;
import jp.sourceforge.armadillo.lzh.*;

/**
 * LZH`A[JCu̓WJB
 */
public final class LzhExpander extends CharacterEncoding implements Expander {

    private LzhInputStream lis;

    /**
     * LzhExpander̐B
     * @param is InputStream
     */
    public LzhExpander(InputStream is) {
        this.lis = new LzhInputStream(is);
    }

    /* @see jp.sourceforge.armadillo.Expander#nextEntry() */
    public ArchiveEntry nextEntry() throws IOException {
        LzhEntry entry = lis.getNextEntry();
        if (entry == null) {
            return ArchiveEntry.NULL;
        }
        ArchiveEntry ae = new ArchiveEntry(entry.getName());
        ae.method = entry.getMethod();
        ae.lastModified = getFileTimestamp(entry);
        ae.size = entry.getSize();
        ae.compressedSize = entry.getCompressedSize();
        ae.crc = entry.getCrc();
        return ae;
    }

    /**
     * t@CXV̎擾B
     * @param entry 
     * @return t@CXV
     */
    private long getFileTimestamp(LzhEntry entry) {
        if (entry.getFileTime() > 0) {
            return FILETIME.toMillisecond(entry.getFileTime());
        }
        if (entry.getTimeT() > 0) {
            return TimeT.toMillisecond(entry.getTimeT());
        }
        return FTime.toMillisecond(entry.getFTime());
    }

    /* @see jp.sourceforge.armadillo.Expander#expand(java.io.OutputStream) */
    public long expand(OutputStream os) throws IOException {
        return IOUtilities.transferAll(lis, os);
    }

    /* @see jp.sourceforge.armadillo.Expander#close() */
    public void close() throws IOException {
        lis.close();
    }

}
