package jp.sourceforge.armadillo;

import java.io.*;
import java.text.*;
import java.util.*;

/**
 * IvV͏B
 */
final class OptionParser {

    private final List optionList;

    /**
     * OptionParser̐B
     * @param args R}hp[^
     */
    OptionParser(String[] args) {
        List list = new ArrayList();
        for (int i = 0; i < args.length; i++) {
            String arg = args[i];
            if (i == 0) {
                char[] chars = arg.toCharArray();
                for (int j = 0; j < chars.length; j++) {
                    char c = chars[j];
                    if (c != '-') {
                        list.add("-" + c);
                    }
                }
            } else if (arg.matches("^-[^-]*")) {
                char[] chars = arg.toCharArray();
                for (int j = 1; j < chars.length; j++) {
                    list.add("-" + chars[j]);
                }
            } else {
                list.add(arg);
            }
        }
        this.optionList = list;
    }

    /**
     * c̃p[^擾B
     * @return p[^z
     */
    String[] getRest() {
        return (String[])optionList.toArray(new String[optionList.size()]);
    }

    /**
     * [hoB
     * @param optionList IvVXg
     * @return [h
     * @throws ParseException 
     */
    char parseMode() throws ParseException {
        int index = -1;
        for (int i = 0, n = optionList.size(); i < n; i++) {
            String option = (String)optionList.get(i);
            if (option.matches("-[ctx]")) {
                if (index >= 0) {
                    Object firstMode = optionList.get(index);
                    throw new ParseException("ambiguios mode: " + firstMode + ", " + option, index);
                }
                index = i;
            }
        }
        if (index >= 0) {
            return ((String)optionList.remove(index)).charAt(1);
        } else {
            throw new ParseException("armadillo requires mode option (-c, -x, -t)", index);
        }
    }

    /**
     * A[JCut@CoB
     * @param optionList IvVXg
     * @return A[JCut@C
     * @throws ParseException 
     */
    File parseArchiveFile() throws ParseException {
        final int listSize = optionList.size();
        int index = -1;
        for (int i = 0; i < listSize; i++) {
            String option = (String)optionList.get(i);
            if (option.equals("-f")) {
                if (index >= 0) {
                    throw new ParseException("duplicated option: " + option, index);
                }
                index = i;
            }
        }
        if (index >= 0 && index < listSize - 1) {
            String path = (String)optionList.remove(index + 1);
            optionList.remove(index);
            return new File(path);
        } else {
            throw new ParseException("no archive-file parameter", index);
        }
    }

    /**
     * 璷[hoB
     * @param optionList IvVXg
     * @return 璷[h
     * @throws ParseException 
     */
    boolean parseVerbose() throws ParseException {
        int index = -1;
        for (int i = 0, n = optionList.size(); i < n; i++) {
            String option = (String)optionList.get(i);
            if (option.equals("-v")) {
                if (index >= 0) {
                    throw new ParseException("duplicated option: " + option, index);
                }
                index = i;
            }
        }
        if (index >= 0) {
            optionList.remove(index);
            return true;
        } else {
            return false;
        }
    }

    /**
     * o͐fBNgoB
     * @return o͐fBNg
     * @throws ParseException
     */
    String parseOutputDirectory() throws ParseException {
        final int listSize = optionList.size();
        int index = -1;
        for (int i = 0; i < listSize; i++) {
            String option = (String)optionList.get(i);
            if (option.equals("-d")) {
                if (index >= 0) {
                    throw new ParseException("duplicated option: " + option, index);
                }
                index = i;
            }
        }
        if (index < 0) {
            return "";
        } else if (index < listSize - 1) {
            String path = (String)optionList.remove(index + 1);
            optionList.remove(index);
            return path;
        } else {
            throw new ParseException("no archive-file parameter", index);
        }
    }

    /*
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return optionList.toString();
    }

}
