package jp.sourceforge.armadillo;

import java.io.*;

import jp.sourceforge.armadillo.Utilities.*;
import jp.sourceforge.armadillo.io.*;
import jp.sourceforge.armadillo.tar.*;

/**
 * TarA[JCoB
 */
public final class TarArchiver extends CharacterEncoding implements Archiver {

    private TarOutputStream tos;

    /**
     * TarArchiver̐B
     * @param os OutputStream
     */
    public TarArchiver(OutputStream os) {
        this.tos = new TarOutputStream(os);
    }

    /**
     * TarArchiver̐B
     * @param file Tart@C
     * @throws IOException o̓G[ꍇ 
     */
    public TarArchiver(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    /* @see jp.sourceforge.armadillo.Archiver#addEntry(jp.sourceforge.armadillo.ArchiveEntry, java.io.File) */
    public void addEntry(ArchiveEntry ae, File file) throws IOException {
        if (file.isDirectory()) {
            addDirectoryEntry(ae);
        } else {
            InputStream is = new FileInputStream(file);
            try {
                ae.size = file.length();
                addFileEntry(ae, is);
            } finally {
                is.close();
            }
        }
        ae.setAdded(true);
    }

    /* @see jp.sourceforge.armadillo.Archiver#addEntry(jp.sourceforge.armadillo.ArchiveEntry,
                                                       java.io.InputStream, long) */
    public void addEntry(ArchiveEntry ae, InputStream is, long length) throws IOException {
        if (ae.isDirectory()) {
            addDirectoryEntry(ae);
        } else {
            ae.size = length;
            addFileEntry(ae, is);
        }
        ae.setAdded(true);
    }

    /**
     * fBNgGg̒ǉB
     * @param ae ArchiveEntry
     * @throws IOException o̓G[ꍇ
     */
    private void addDirectoryEntry(ArchiveEntry ae) throws IOException {
        TarEntry entry = createEntry(ae);
        entry.setMode(TarEntry.DEFAULT_DIR_MODE);
        tos.putNextEntry(entry);
        tos.closeEntry();
        ae.crc = 0L;
        ae.size = 0L;
        ae.compressedSize = 0L;
    }

    /**
     * t@CGg̒ǉB
     * @param ae ArchiveEntry
     * @param is InputStream
     * @throws IOException o̓G[ꍇ
     */
    private void addFileEntry(ArchiveEntry ae, InputStream is) throws IOException {
        TarEntry entry = createEntry(ae);
        entry.setSize(ae.size);
        tos.putNextEntry(entry);
        long size = IOUtilities.transferAll(is, tos);
        entry.setSize(size);
        tos.closeEntry();
        assert size == ae.size : "file size";
        assert entry.getSize() == ae.size : "file size";
        ae.crc = 0L;
        ae.size = size;
        ae.compressedSize = size;
    }

    /**
     * Gg̐B
     * @param ae ArchiveEntry
     * @return TarEntry
     */
    private TarEntry createEntry(ArchiveEntry ae) {
        String name = ae.name;
        TarEntry entry = new TarEntry(name);
        if (usesEncoding) {
            entry.setNameAsBytes(encode(name));
        }
        entry.setTimeT(TimeT.convert(ae.lastModified));
        return entry;
    }

    /* @see jp.sourceforge.armadillo.Archiver#close() */
    public void close() throws IOException {
        tos.close();
    }

}
