package jp.sourceforge.armadillo;

import java.io.*;

import jp.sourceforge.armadillo.Utilities.*;
import jp.sourceforge.armadillo.io.*;
import jp.sourceforge.armadillo.tar.*;

/**
 * TarA[JCuWJB
 */
public final class TarExpander extends CharacterEncoding implements Expander {

    private TarInputStream tis;

    /**
     * TarExpander̐B
     * @param is InputStream
     */
    public TarExpander(InputStream is) {
        this.tis = new TarInputStream(is);
    }

    /* @see jp.sourceforge.armadillo.Expander#nextEntry() */
    public ArchiveEntry nextEntry() throws IOException {
        TarEntry entry = tis.getNextEntry();
        if (entry == null) {
            return ArchiveEntry.NULL;
        }
        ArchiveEntry ae = new ArchiveEntry(entry.getName());
        if (usesEncoding) {
            ae.name = decode(entry.getNameAsBytes());
        }
        ae.lastModified = TimeT.toMillisecond(entry.getTimeT());
        ae.size = entry.getSize();
        return ae;
    }

    /* @see jp.sourceforge.armadillo.Expander#expand(java.io.OutputStream) */
    public long expand(OutputStream os) throws IOException {
        return IOUtilities.transferAll(tis, os);
    }

    /* @see jp.sourceforge.armadillo.Expander#close() */
    public void close() throws IOException {
        tis.close();
    }

}
