package jp.sourceforge.armadillo;

import java.io.*;
import java.util.*;

/**
 * [eBeB\bhNXB
 */
public final class Utilities {

    /**
     * Utilities̐B
     */
    private Utilities() {
        // empty
    }

    /**
     * t@CGg擾B
     * @param file t@C
     * @return Gg
     */
    public static String getEntryName(File file) {
        String entryName = file.getPath().replace('\\', '/');
        if (file.isDirectory() && !entryName.endsWith(String.valueOf('/'))) {
            entryName += '/';
        }
        return entryName;
    }

    /**
     * ͂擾B
     * @return 
     * @throws IOException o̓G[ꍇ 
     */
    public static String getInput() throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        return in.readLine();
    }

    /**
     * time_t`B
     * UNIXŎgpB
     * 32rbglB
     */
    public static final class TimeT {

        private TimeT() {
            // empty
        }

        /**
         * time_tɕϊB
         * @param millisecond ~b
         * @return time_tl
         */
        public static int convert(long millisecond) {
            // 2038N͖
            return (int)((millisecond / 1000L) & 0xFFFFFFFF);
        }

        /**
         * ~bɕϊB
         * @param timeT time_tl
         * @return ~b
         */
        public static long toMillisecond(int timeT) {
            return timeT * 1000L;
        }

    }

    /**
     * ftime`B
     * 32rbglB
     * DOSŎgpB
     */
    public static final class FTime {

        private FTime() {
            // empty
        }

        /**
         * ftimeɕϊB
         * @param millisecond ~b
         * @return ftimel
         */
        public static int convert(long millisecond) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(millisecond);
            return (c.get(Calendar.YEAR) - 1980) << 25
                   | (c.get(Calendar.MONTH) + 1) << 21
                   | c.get(Calendar.DATE) << 16
                   | c.get(Calendar.HOUR_OF_DAY) << 11
                   | c.get(Calendar.MINUTE) << 5
                   | (c.get(Calendar.SECOND) / 2);
        }

        /**
         * ~bɕϊB
         * @param ftime ftimel
         * @return ~b
         */
        public static long toMillisecond(int ftime) {
            int year = (ftime >>> 25 & 0x7F) + 1980;
            int month = ftime >>> 21 & 0x0F;
            int day = ftime >>> 16 & 0x1F;
            int hours = ftime >>> 11 & 0x1F;
            int minutes = ftime >>> 5 & 0x3F;
            int seconds = (ftime & 0x1F) * 2;
            Calendar c = Calendar.getInstance();
            c.set(year, month - 1, day, hours, minutes, seconds);
            return c.getTimeInMillis();
        }

    }

    /**
     * FILETIME`B
     * 64rbglB
     * WindowsŎgpB
     */
    public static final class FILETIME {

        // Java~bG|bNƂ̍(369years * 365days * 86400secs * 1000000 + [N)
        private static final long DIFFERENCE = 116444736000000000L;

        private FILETIME() {
            // empty
        }

        /**
         * FILETIMEɕϊB
         * @param millisecond ~b
         * @return FILETIMEl
         */
        public static long convert(long millisecond) {
            return millisecond * 10000L + DIFFERENCE;
        }

        /**
         * ~bɕϊB
         * @param filetime FILETIMEl
         * @return ~b
         */
        public static long toMillisecond(long filetime) {
            return (filetime - DIFFERENCE) / 10000L;
        }

    }

    /**
    * DOS`B
    * @deprecated ̃NX{@link FTime}ɒu܂B
    */
    public static final class DosTime {

        /**
         * Utilities.DosTime̐B
         */
        private DosTime() {
            // empty
        }

        /**
         * DOS`̒l擾B
         * @param milliseconds ~b`
         * @return DOS`(32bitl)
         */
        public static int getValue(long milliseconds) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(milliseconds);
            return (c.get(Calendar.YEAR) - 1980) << 25
                   | (c.get(Calendar.MONTH) + 1) << 21
                   | c.get(Calendar.DATE) << 16
                   | c.get(Calendar.HOUR_OF_DAY) << 11
                   | c.get(Calendar.MINUTE) << 5
                   | (c.get(Calendar.SECOND) / 2);
        }

        /**
         * DOS`~b`ɕϊB
         * @param dostime DOS`
         * @return ~b`
         */
        public static long toMilliSeconds(int dostime) {
            int year = (dostime >>> 25 & 0x7F) + 1980;
            int month = dostime >>> 21 & 0x0F;
            int day = dostime >>> 16 & 0x1F;
            int hours = dostime >>> 11 & 0x1F;
            int minutes = dostime >>> 5 & 0x3F;
            int seconds = (dostime & 0x1F) * 2;
            Calendar c = Calendar.getInstance();
            c.set(year, month - 1, day, hours, minutes, seconds);
            return c.getTimeInMillis();
        }

    }

    /**
     * Windows`̕ϊB
     * @deprecated ̃NX{@link FTime}ɒu܂B
     */
    public static final class WindowsTime {

        /**
         * Utilities.WindowsTime̐B
         */
        private WindowsTime() {
            // empty
        }

        /**
         * Windows`~b`ɕϊB
         * @param fileTime Windows`
         * @return ~b`
         */
        public static long toMilliSeconds(long fileTime) {
            // (FILETIME - 369years * 365days * 86400secs * 1000000) / 10000
            return ((fileTime >>> 1) - 58222368000000000L) / 5000;
        }

    }

}
