package jp.sourceforge.armadillo;

import java.io.*;
import java.nio.channels.*;

import jp.sourceforge.armadillo.Utilities.*;
import jp.sourceforge.armadillo.io.*;
import jp.sourceforge.armadillo.zip.*;

/**
 * ZipA[JCoB
 */
public final class ZipArchiver extends CharacterEncoding implements Archiver {

    private ZipOutputStream zos;

    /**
     * ZipArchiver̐B
     * @param os OutputStream
     */
    public ZipArchiver(OutputStream os) {
        this.zos = new ZipOutputStream(os);
    }

    /* @see jp.sourceforge.armadillo.Archiver#addEntry(jp.sourceforge.armadillo.ArchiveEntry, java.io.File) */
    public void addEntry(ArchiveEntry ae, File file) throws IOException {
        final long fileSize = file.length();
        if (file.isDirectory()) {
            addDirectoryEntry(ae);
        } else {
            ae.size = fileSize;
            if (fileSize > 0) {
                RandomAccessFile r = new RandomAccessFile(file, "r");
                try {
                    FileChannel fch = r.getChannel();
                    InputStream is = Channels.newInputStream(fch);
                    ArchiveEntry trialEntry = new ArchiveEntry(ae.name);
                    tryOut(trialEntry, is);
                    ae.crc = trialEntry.crc;
                    long deflatedSize = trialEntry.compressedSize;
                    fch.position(0L);
                    if (deflatedSize < fileSize) {
                        ae.compressedSize = deflatedSize;
                    } else {
                        ae.compressedSize = fileSize;
                    }
                    addFileEntry(ae, is);
                } finally {
                    r.close();
                }
            } else {
                addFileEntry(ae, null);
            }
        }
        ae.setAdded(true);
    }

    /* @see jp.sourceforge.armadillo.Archiver#addEntry(jp.sourceforge.armadillo.ArchiveEntry,
     *                                                 java.io.InputStream, long) */
    public void addEntry(ArchiveEntry ae, InputStream is, long length) throws IOException {
        if (ae.isDirectory()) {
            addDirectoryEntry(ae);
        } else {
            ae.size = length;
            addFileEntry(ae, is);
        }
        ae.setAdded(true);
    }

    /**
     * fBNgGg̒ǉB
     * @param ae ArchiveEntry
     * @throws IOException o̓G[ꍇ
     */
    private void addDirectoryEntry(ArchiveEntry ae) throws IOException {
        ZipEntry entry = createEntry(ae);
        entry.setMethod(ZipEntry.STORED);
        entry.setCrc(0L);
        entry.setSize(0L);
        entry.setCompressedSize(0L);
        entry.setFTime(TimeT.convert(ae.lastModified));
        zos.putNextEntry(entry);
        zos.closeEntry();
    }

    /**
     * t@CGg̒ǉB
     * @param ae ArchiveEntry
     * @param is InputStream (o̓TCY0̏ꍇ <code>null</code> e)
     * @throws IOException o̓G[ꍇ
     */
    private void addFileEntry(ArchiveEntry ae, InputStream is) throws IOException {
        final long fileSize = ae.size;
        final long compressedSize = ae.compressedSize;
        ZipEntry entry = createEntry(ae);
        if (compressedSize <= 0) {
            entry.setOption((short)8); // EXTwb_
        }
        if (compressedSize > 0 && compressedSize < fileSize) {
            entry.setMethod(ZipEntry.DEFLATED);
        } else {
            entry.setMethod(ZipEntry.STORED);
        }
        entry.setCrc(ae.crc);
        entry.setSize(fileSize);
        entry.setCompressedSize(ae.compressedSize);
        zos.putNextEntry(entry);
        long size = 0;
        if (fileSize > 0) {
            size = IOUtilities.transferAll(is, zos);
        }
        zos.closeEntry();
        assert size == fileSize : "file size";
        assert entry.getSize() == fileSize : "file size";
        assert entry.getCompressedSize() == compressedSize : "comp size";
        ae.crc = entry.getCrc();
        ae.size = size;
        ae.compressedSize = compressedSize;
    }

    /**
     * ksB
     * @param ae ArchiveEntry
     * @param is InputStream
     * @throws IOException o̓G[ꍇ
     */
    private void tryOut(ArchiveEntry ae, InputStream is) throws IOException {
        ZipEntry entry = createEntry(ae);
        VolumetricOutputStream detector = new VolumetricOutputStream();
        ZipOutputStream zos = new ZipOutputStream(detector);
        try {
            entry.setOption((short)8);
            entry.setMethod(ZipEntry.DEFLATED);
            zos.putNextEntry(entry);
            IOUtilities.transferAll(is, zos);
            zos.closeEntry();
        } finally {
            zos.close();
        }
        assert entry.getCompressedSize() == detector.getSize();
        ae.crc = entry.getCrc();
        ae.size = entry.getSize();
        ae.compressedSize = entry.getCompressedSize();
    }

    /**
     * Gg̐B
     * @param ae ArchiveEntry
     * @return ZipEntry
     */
    private ZipEntry createEntry(ArchiveEntry ae) {
        String name = ae.name;
        ZipEntry entry = new ZipEntry(name);
        if (usesEncoding) {
            entry.setNameAsBytes(encode(name));
        }
        entry.setFTime(FTime.convert(ae.lastModified));
        return entry;
    }

    /* @see jp.sourceforge.armadillo.Archiver#close() */
    public void close() throws IOException {
        zos.close();
    }

}
