package jp.sourceforge.armadillo.io;

import java.io.*;

/**
 * A[JCu̓̓Xg[B
 */
public abstract class ArchiveInputStream extends FilterInputStream {

    /**
     * ̃tB[h <code>null</code> ̏ꍇ́Aڐڑiwb_ǂݎ莞j
     * <code>null</code>łȂꍇ́AfR[_oRiGgǂݎ莞j
     */
    protected InputStream frontStream;
    protected long remaining;

    private boolean closed;

    /**
     * ArchiveInputStream̐B
     * @param is InputStream
     */
    public ArchiveInputStream(InputStream is) {
        super(is);
        this.closed = false;
        this.remaining = 0;
    }

    /**
     * Xg[JĂ邱ƂmFB
     * @throws IOException Xg[ɕĂꍇ
     */
    protected final void ensureOpen() throws IOException {
        if (closed) {
            throw new IOException("stream closed");
        }
    }

    /* @see java.io.FilterInputStream#read() */
    public int read() throws IOException {
        ensureOpen();
        if (frontStream == null) {
            return super.read();
        } else if (remaining <= 0) {
            assert remaining == 0;
            return -1;
        } else {
            int read = frontStream.read();
            if (read == -1) {
                return -1;
            }
            --remaining;
            return read;
        }
    }

    /* @see java.io.FilterInputStream#read(byte[], int, int) */
    public int read(byte[] b, int off, int len) throws IOException {
        ensureOpen();
        if (frontStream == null) {
            return super.read(b, off, len);
        } else if (remaining <= 0) {
            assert remaining == 0;
            return -1;
        } else {
            long requiredLength = Math.min(len, remaining);
            assert requiredLength <= Integer.MAX_VALUE;
            int readLength = frontStream.read(b, off, (int)requiredLength);
            assert readLength != 0 : "Read Zero";
            if (readLength >= 0) {
                remaining -= readLength;
            }
            return readLength;
        }
    }

    /* @see java.io.FilterInputStream#skip(long) */
    public long skip(long n) throws IOException {
        ensureOpen();
        if (frontStream == null) {
            return super.skip(n);
        } else if (remaining <= 0) {
            assert remaining == 0;
            return -1;
        } else {
            long skipped = frontStream.skip(n);
            if (skipped > 0) {
                remaining -= skipped;
            }
            return skipped;
        }
    }

    /* @see java.io.FilterInputStream#available() */
    public int available() throws IOException {
        return 0;
    }

    /* @see java.io.FilterInputStream#markSupported() */
    public boolean markSupported() {
        return false;
    }

    /* @see java.io.FilterInputStream#mark(int) */
    public synchronized void mark(int limit) {
        // not supported
    }

    /* @see java.io.FilterInputStream#reset() */
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    /* @see java.io.FilterInputStream#close() */
    public void close() throws IOException {
        ensureOpen();
        try {
            super.close();
        } finally {
            frontStream = null;
            closed = true;
        }
    }

}
