package jp.sourceforge.armadillo.io;

import java.io.*;

/**
 * A[JCȕo̓Xg[B
 */
public abstract class ArchiveOutputStream extends FilterOutputStream {

    protected OutputStream frontStream;
    protected long written;

    private boolean closed;

    /**
     * ArchiveOutputStream̐B
     * @param out OutputStream
     */
    public ArchiveOutputStream(OutputStream out) {
        super(out);
    }

    /**
     * Xg[JĂ邱ƂmFB
     * @throws IOException Xg[ɕĂꍇ
     */
    protected final void ensureOpen() throws IOException {
        if (closed) {
            throw new IOException("stream closed");
        }
    }

    /* @see java.io.FilterOutputStream#write(int) */
    public void write(int b) throws IOException {
        ensureOpen();
        if (frontStream == null) {
            super.write(b);
        } else {
            frontStream.write(b);
        }
        ++written;
    }

    /* @see java.io.FilterOutputStream#write(byte[], int, int) */
    public void write(byte[] b, int off, int len) throws IOException {
        ensureOpen();
        if (frontStream == null) {
            super.write(b, off, len);
        } else {
            frontStream.write(b, off, len);
        }
        written += len;
    }

    /* @see java.io.FilterOutputStream#flush() */
    public void flush() throws IOException {
        ensureOpen();
        if (frontStream == null) {
            super.flush();
        } else {
            frontStream.flush();
        }
    }

    /* @see java.io.FilterOutputStream#close() */
    public void close() throws IOException {
        try {
            flush();
        } finally {
            closed = true;
            frontStream = null;
            super.close();
        }
    }

}
