package jp.sourceforge.armadillo.io;

import java.io.*;

/**
 * eʑ̏o̓Xg[B
 * f[^̃TCŶ݌vAo͓e͔jB 
 */
public final class VolumetricOutputStream extends FilterOutputStream {

    private long size;

    /**
     * SizeDetectionOutputStream̐B
     */
    public VolumetricOutputStream() {
        super(null);
        this.size = 0;
    }

    /**
     * ܂ꂽf[^̃TCY̎擾B
     * @return TCY
     */
    public long getSize() {
        return size;
    }

    /* @see java.io.FilterOutputStream#write(int) */
    public void write(int b) throws IOException {
        ++size;
    }

    /* @see java.io.FilterOutputStream#write(byte[]) */
    public void write(byte[] b) throws IOException {
        size += b.length;
    }

    /* @see java.io.FilterOutputStream#write(byte[], int, int) */
    public void write(byte[] b, int off, int len) throws IOException {
        assert b != null && b.length > len - off : "null buffer";
        size += len;
    }

    /* @see java.io.FilterOutputStream#flush() */
    public void flush() throws IOException {
        // empty
    }

    /* @see java.io.FilterOutputStream#close() */
    public void close() throws IOException {
        // empty
    }

}
