package jp.sourceforge.armadillo.lzh;

import java.util.zip.*;

/**
 * CRC16B
 */
public final class CRC16 implements Checksum {

    private final int[] table;
    private final int initial;

    private int value;

    /**
     * CRC16̐B
     */
    public CRC16() {
        this(0xA001, 0);
    }

    /**
     * CRC16̐B
     * @param exp 
     * @param initial l 
     */
    CRC16(int exp, int initial) {
        this.table = create(exp);
        this.initial = initial;
        this.value = initial;
    }

    /**
     * e[u̐B
     * @param exp 
     * @return e[u
     */
    static int[] create(int exp) {
        int[] table = new int[256];
        for (int i = 0; i < table.length; i++) {
            table[i] = i;
            for (int j = 0; j < 8; j++) {
                if ((table[i] & 0x01) != 0) {
                    table[i] = (table[i] >> 1) ^ exp;
                } else {
                    table[i] >>= 1;
                }
            }
        }
        return table;
    }

    /**
     * CRCl̎擾B
     * @return CRCl(short)
     */
    public short getShortValue() {
        return (short)(value & 0xFFFF);
    }

    /* @see java.util.zip.Checksum#getValue() */
    public long getValue() {
        return value;
    }

    /* @see java.util.zip.Checksum#reset() */
    public void reset() {
        value = initial;
    }

    /* @see java.util.zip.Checksum#update(int) */
    public void update(int b) {
        int value = this.value;
        value = (value >> 8) ^ table[(value ^ b) & 0xFF];
        this.value = value;
    }

    /* @see java.util.zip.Checksum#update(byte[], int, int) */
    public void update(byte[] bytes, int offset, int length) {
        int value = this.value;
        for (int i = offset; i < offset + length; i++) {
            value = (value >> 8) ^ table[(value ^ bytes[i]) & 0xFF];
        }
        this.value = value;
    }

}