package jp.sourceforge.armadillo.lzh;

import java.io.*;
import java.nio.*;
import java.nio.channels.*;

/**
 * LZH`A[JCũwb_B
 * 
 * <h3>wb_̎dlɂ</h3>
 * <p>ɋLڂẮAȎdlł͂ȂƂɒӁB</p>
 * <ul>
 * <li>wb_3(wb_x: 0,1,2)Af[^̒OɒuB</li>
 * <li>l(byte,short,int,long)́AgGfBAŊi[B</li>
 * <li>ŏIXV̌`́Awb_̎ނɂĈقȂB</li>
 * </ul>
 */
public final class LzhHeader {

    /**
     * <code>wb_x0</code>
     */
    public static final byte HEADER_LEVEL_0 = 0;
    /**
     * <code>wb_x1</code>
     */
    public static final byte HEADER_LEVEL_1 = 1;
    /**
     * <code>wb_x2</code>
     */
    public static final byte HEADER_LEVEL_2 = 2;

    private static final int BUFFER_SIZE = 1024;
    private static final int LEVEL_OFFSET = 20;
    private static final byte FILETYPE_FILE = 0x20;
    private static final byte PLATFORM_JAVA = 'J';
    private static final byte PATH_DELIMITER = (byte)0xFF;
    private static final String ISO_8859_1 = "iso-8859-1";
    private static final String ERROR_PREFIX = "invalid header: ";

    private ByteBuffer buffer;

    /**
     * LzhHeader̐B
     */
    public LzhHeader() {
        this.buffer = ByteBuffer.allocate(BUFFER_SIZE).order(ByteOrder.LITTLE_ENDIAN);
    }

    /**
     * wb_ǂݍށB
     * @param is InputStream
     * @return LzhEntry
     * @throws IOException o̓G[ꍇ
     */
    public LzhEntry read(InputStream is) throws IOException {
        buffer.clear();
        buffer.limit(LEVEL_OFFSET + 1);
        Channels.newChannel(is).read(buffer);
        int readLength = buffer.position();
        if (readLength == 0
            || (readLength == 1 && buffer.get(0) == 0x00)
            || (readLength <= LEVEL_OFFSET + 1 && buffer.getShort(0) == 0x00)) {
            return null;
        }
        if (readLength != LEVEL_OFFSET + 1) {
            // warn: next header length
            return null;
        }
        int level = buffer.get(LEVEL_OFFSET);
        buffer.rewind();
        int headerLength;
        switch (level) {
            case 0:
            case 1:
                headerLength = (buffer.get() & 0xFF) + 2;
                break;
            case 2:
                headerLength = buffer.getShort() & 0xFFFF;
                break;
            default:
                throw new LzhException("unsupported header level (=" + level + ")");
        }
        if (headerLength == 0) {
            return null;
        }
        assert headerLength >= 0 && headerLength < BUFFER_SIZE : "header length = " + headerLength;
        buffer.limit(headerLength);
        buffer.position(LEVEL_OFFSET + 1);
        Channels.newChannel(is).read(buffer);
        if (buffer.position() != headerLength) {
            throw new LzhException(ERROR_PREFIX + "header length = " + headerLength);
        }
        LzhEntry entry;
        switch (level) {
            case 0:
                entry = readLevel0();
                break;
            case 1:
                entry = readLevel1(is);
                break;
            case 2:
                entry = readLevel2();
                break;
            default:
                throw new IllegalStateException("unexpected state");
        }
        assert entry.headerLength == headerLength;
        if (!entry.directory) {
            if (entry.name.endsWith("/") || entry.getMethod().equals(LzhMethod.LHD)) {
                entry.directory = true;
            }
        }
        return entry;
    }

    /**
     * xOwb_ǂݍށB
     * @return LzhEntry
     * @throws LzhException `FbNTs̏ꍇ
     */
    private LzhEntry readLevel0() throws LzhException {
        buffer.position(0);
        LzhEntry entry = new LzhEntry();
        entry.headerLength = (buffer.get() & 0xFF) + 2;
        entry.checksum = (buffer.get() & 0xFF);
        entry.calculatedChecksum = calculateChecksum(2, buffer.limit());
        entry.method = new String(getBytes(5));
        entry.compressedSize = buffer.getInt();
        entry.size = buffer.getInt();
        entry.ftime = buffer.getInt();
        entry.type = buffer.get();
        entry.headerLevel = buffer.get();
        assert entry.headerLevel == HEADER_LEVEL_0;
        final int nameLength = buffer.get() & 0xFF;
        byte[] nameAsBytes = getBytes(nameLength);
        entry.name = new String(nameAsBytes);
        entry.nameAsBytes = nameAsBytes;
        if (buffer.limit() > buffer.position() + 2) {
            entry.crc = buffer.getShort();
        } else if (buffer.limit() > buffer.position() + 1) {
            entry.crc = buffer.get();
        }
        return entry;
    }

    /**
     * xPwb_ǂݍށB
     * @param is InputStream
     * @return LzhEntry
     * @throws IOException o̓G[ꍇ 
     */
    private LzhEntry readLevel1(InputStream is) throws IOException {
        buffer.position(0);
        LzhEntry entry = new LzhEntry();
        entry.headerLength = (buffer.get() & 0xFF) + 2;
        entry.checksum = (buffer.get() & 0xFF);
        entry.calculatedChecksum = calculateChecksum(2, buffer.limit());
        entry.method = new String(getBytes(5));
        int skipSize = buffer.getInt();
        entry.size = buffer.getInt();
        entry.ftime = buffer.getInt();
        final byte reserved = buffer.get();
        assert reserved == FILETYPE_FILE;
        entry.headerLevel = buffer.get();
        assert entry.headerLevel == HEADER_LEVEL_1;
        int nameLength = buffer.get() & 0xFF;
        byte[] nameAsBytes = getBytes(nameLength);
        entry.name = new String(nameAsBytes);
        entry.nameAsBytes = nameAsBytes;
        entry.crc = buffer.getShort();
        entry.type = buffer.get();
        int extendedHeaderSize = 0;
        entry.compressedSize = skipSize - extendedHeaderSize;
        return entry;
    }

    /**
     * xQwb_ǂݍށB
     * @return LzhEntry
     * @throws IOException o̓G[ꍇ 
     */
    private LzhEntry readLevel2() throws IOException {
        buffer.position(0);
        LzhEntry entry = new LzhEntry();
        entry.headerLength = buffer.getShort();
        entry.method = new String(getBytes(5));
        entry.compressedSize = buffer.getInt();
        entry.size = buffer.getInt();
        entry.timeT = buffer.getInt();
        final byte reserved = buffer.get();
        assert reserved == FILETYPE_FILE;
        entry.headerLevel = buffer.get();
        assert entry.headerLevel == HEADER_LEVEL_2;
        entry.crc = buffer.getShort();
        entry.osIdentifier = (char)buffer.get();
        int warningCount = 0;
        short nextHeaderLength = 0;
        boolean isDirectory = false;
        ByteArrayOutputStream nameBuffer = new ByteArrayOutputStream();
        while ((nextHeaderLength = buffer.getShort()) > 0) {
            int length = nextHeaderLength - 3;
            byte identifier = buffer.get();
            buffer.mark();
            switch (identifier) {
                case 0x00: // common
                    buffer.getShort(); // header CRC
                    break;
                case 0x01: // file name
                    nameBuffer.write(nextPath(length));
                    isDirectory = false;
                    break;
                case 0x02: // dir name
                    nameBuffer.write(nextPath(length));
                    isDirectory = true;
                    break;
                case 0x39: // plural disk
                    ++warningCount;
                    break;
                case 0x41: // MS Windows timestamp
                    buffer.getLong(); // ctime
                    entry.fileTime = buffer.getLong();
                    buffer.getLong(); // atime
                    break;
                case 0x42: // MS filesize
                    entry.compressedSize = buffer.getLong();
                    entry.size = buffer.getLong();
                    break;
                case 0x54: // UNIX time_t
                    entry.timeT = buffer.get();
                    break;
                case 0x3F: // comment
                case 0x40: // MS attribute
                case 0x50: // UNIX permission
                case 0x51: // UNIX uid gid
                case 0x52: // UNIX group
                case 0x53: // UNIX user
                case 0x7D: // capsule
                case 0x7E: // extended attribute
                default:
                    // ignore
            }
            buffer.reset();
            buffer.position(buffer.position() + length);
        }
        byte[] nameAsBytes = nameBuffer.toByteArray();
        entry.name = new String(nameAsBytes);
        entry.nameAsBytes = nameAsBytes;
        entry.directory = isDirectory;
        assert warningCount == 0;
        return entry;
    }

    /**
     * wb_ށB
     * @param os OutputStream
     * @param entry LzhEntry
     * @throws IOException o̓G[ꍇ
     * @throws LzhException GgesK؂ȏꍇ
     */
    public void write(OutputStream os, LzhEntry entry) throws IOException {
        if (!entry.method.matches("-l[hz][a-z0-9]-")) {
            throw new LzhException("invalid compression type: " + entry.method);
        }
        if (entry.compressedSize > Integer.MAX_VALUE) {
            throw new LzhException("too large compressed size: " + entry.compressedSize);
        }
        if (entry.size > Integer.MAX_VALUE) {
            throw new LzhException("too large size: " + entry.size);
        }
        buffer.clear();
        switch (entry.headerLevel) {
            case HEADER_LEVEL_0:
                writeLevel0(entry);
                break;
            case HEADER_LEVEL_1:
                writeLevel1(entry);
                break;
            case HEADER_LEVEL_2:
                writeLevel2(entry);
                break;
            default:
                throw new IllegalArgumentException(ERROR_PREFIX
                                                   + "header-level="
                                                   + entry.headerLevel);
        }
        buffer.flip();
        Channels.newChannel(os).write(buffer);
    }

    /**
     * xOwb_ށB
     * @param entry LzhEntry
     * @throws IOException o̓G[ꍇ
     */
    private void writeLevel0(LzhEntry entry) throws IOException {
        assert entry.compressedSize >= 0 && entry.compressedSize <= Integer.MAX_VALUE;
        assert entry.size >= 0 && entry.size <= Integer.MAX_VALUE;
        byte[] nameBytes = getNameAsByte(entry);
        final byte nameLength = (byte)(nameBytes.length & 0xFF);
        final int extendedHeaderSize = 0;

        buffer.position(2);
        buffer.put(entry.method.getBytes(ISO_8859_1));
        buffer.putInt(0); // SkipSize
        buffer.putInt((int)entry.size);
        buffer.putInt(entry.ftime);
        buffer.put(FILETYPE_FILE);
        buffer.put(HEADER_LEVEL_0);
        buffer.put(nameLength);
        buffer.put(nameBytes);
        buffer.putShort(entry.crc);

        final int end = buffer.position();
        final int size = end;
        assert size >= LEVEL_OFFSET && size < 256;
        buffer.put(0, (byte)(size - 2));
        if (entry.compressedSize > 0) {
            buffer.putInt(7, calculateSkipSize(entry, size, extendedHeaderSize));
        }
        int checksum = calculateChecksum(2, end);
        buffer.put(1, (byte)(checksum & 0xFF));
    }

    /**
     * xPwb_ށB
     * @param entry LzhEntry
     * @throws IOException o̓G[ꍇ
     */
    private void writeLevel1(LzhEntry entry) throws IOException {
        assert entry.compressedSize >= 0 && entry.compressedSize <= Integer.MAX_VALUE;
        assert entry.size >= 0 && entry.size <= Integer.MAX_VALUE;
        byte[] nameBytes = getNameAsByte(entry);
        final byte nameLength = (byte)(nameBytes.length & 0xFF);
        final short extendedHeaderSize = 0;

        buffer.position(2);
        buffer.put(entry.method.getBytes(ISO_8859_1));
        buffer.putInt(0); // SkipSize
        buffer.putInt((int)entry.size);
        buffer.putInt(entry.ftime);
        buffer.put(FILETYPE_FILE);
        buffer.put(HEADER_LEVEL_1);
        buffer.put(nameLength);
        buffer.put(nameBytes);
        buffer.putShort(entry.crc);
        buffer.put(PLATFORM_JAVA);
        buffer.putShort(extendedHeaderSize);
        buffer.put((byte)0);

        final int end = buffer.position();
        final int size = end;
        assert size >= LEVEL_OFFSET && size < 256;
        buffer.put(0, (byte)(size - 2));
        if (entry.compressedSize > 0) {
            buffer.putInt(7, calculateSkipSize(entry, size, extendedHeaderSize));
        }
        int checksum = calculateChecksum(2, end);
        buffer.put(1, (byte)(checksum & 0xFF));
    }

    /**
     * xQwb_ށB
     * @param entry LzhEntry
     * @throws IOException o̓G[ꍇ 
     */
    private void writeLevel2(LzhEntry entry) throws IOException {
        assert entry.compressedSize >= 0 && entry.compressedSize <= Integer.MAX_VALUE;
        assert entry.size >= 0 && entry.size <= Integer.MAX_VALUE;

        buffer.position(2);
        buffer.put(entry.method.getBytes(ISO_8859_1));
        buffer.putInt(0);
        buffer.putInt((int)entry.size);
        buffer.putInt(entry.timeT);
        buffer.put(FILETYPE_FILE);
        buffer.put(HEADER_LEVEL_2);
        buffer.putShort(entry.crc);
        buffer.put(PLATFORM_JAVA);

        /* extended */
        // name
        byte[] nameBytes = getNameAsByte(entry);
        int offset = 0;
        for (int i = 0; i < nameBytes.length; i++) {
            byte b = nameBytes[i];
            if (b == '/' || b == '\\') {
                nameBytes[i] = PATH_DELIMITER;
                offset = i;
            }
        }
        final int dirLength = offset + 1;
        // 0x00 common
        buffer.putShort((short)5);
        buffer.put((byte)0x00);
        final int crcIndex = buffer.position();
        buffer.putShort((short)0); // CRC
        // 0x02 dir name
        buffer.putShort((short)(dirLength + 3));
        buffer.put((byte)0x02);
        buffer.put(nameBytes, 0, dirLength);
        // 0x01 file name
        int length = nameBytes.length - dirLength;
        buffer.putShort((short)(length + 3));
        buffer.put((byte)0x01);
        buffer.put(nameBytes, dirLength, length);
        buffer.putShort((short)0); // no next
        // header size
        short size = 0;
        size += buffer.position();
        if (size % 256 == 0) {
            buffer.put((byte)0x00);
            ++size;
        }
        buffer.putShort(0, size);
        if (entry.compressedSize > 0) {
            // skip size
            buffer.putInt(7, calculateSkipSize(entry, size, 0));
        }
        // header CRC
        CRC16 crc = new CRC16();
        crc.reset();
        crc.update(buffer.array(), 0, size);
        buffer.putShort(crcIndex, crc.getShortValue());
    }

    /**
     * checksumZoB
     * @param start vZΏۂ̊Jnʒu
     * @param end vZΏۂ̏Iʒu
     * @return checksum
     */
    private int calculateChecksum(int start, int end) {
        int sum = 0;
        for (int i = start; i < end; i++) {
            sum += buffer.get(i);
        }
        return sum;
    }

    /**
     * XLbvTCYZoB
     * @param entry LzhEntry
     * @param headerSize wb_TCY
     * @param extendedHeaderSize gwb_TCY
     * @return XLbvTCY
     * @throws LzhException 
     */
    private static int calculateSkipSize(LzhEntry entry, int headerSize, int extendedHeaderSize) throws LzhException {
        assert entry.compressedSize >= 0 && entry.compressedSize <= Integer.MAX_VALUE;
        assert entry.size >= 0 && entry.size <= Integer.MAX_VALUE;
        assert headerSize >= 0 && extendedHeaderSize >= 0;
        int skipSize = 0;
        if (LzhMethod.isCompressing(entry.getMethod())) {
            skipSize += entry.compressedSize;
            skipSize -= headerSize;
        } else {
            skipSize += entry.size;
        }
        skipSize += extendedHeaderSize;
        assert skipSize >= 0 : "skip size = " + skipSize;
        return skipSize;
    }

    /**
     * oCg̎擾B
     * @param length 
     * @return oCg
     */
    private byte[] getBytes(int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; i++) {
            bytes[i] = buffer.get();
        }
        return bytes;
    }

    /**
     * pX̎擾B
     * @param length 
     * @return oCg
     */
    private byte[] nextPath(int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        for (int i = 0; i < length; i++) {
            if ((bytes[i] & PATH_DELIMITER) == PATH_DELIMITER) {
                bytes[i] = '/';
            }
        }
        return bytes;
    }

    /**
     * GgoCgƂĎ擾B
     * @param entry LzhEntry
     * @return oCg
     */
    private byte[] getNameAsByte(LzhEntry entry) {
        if (entry.nameAsBytes == null) {
            entry.nameAsBytes = entry.name.getBytes();
        }
        return (byte[])entry.nameAsBytes.clone();
    }

}
