package jp.sourceforge.armadillo.lzh;

import java.io.*;

import jp.sourceforge.armadillo.io.*;

/**
 * LZH`A[JCȕo̓Xg[B
 */
public final class LzhOutputStream extends ArchiveOutputStream {

    private LzhHeader header;
    private CRC16 crc;

    /**
     * LzhOutputStream̐B
     * @param os OutputStream
     */
    public LzhOutputStream(OutputStream os) {
        super(os);
        this.header = new LzhHeader();
        this.crc = new CRC16();
        this.frontStream = os;
    }

    /**
     * GgǉB
     * wb_͑ɏ܂B
     * @param entry LzhEntry
     * @throws IOException o̓G[ꍇ
     */
    public void putNextEntry(LzhEntry entry) throws IOException {
        String compressingType = entry.getMethod();
        LzhMethod method = new LzhMethod(compressingType);
        if (method.isCompressing()) {
            frontStream = new LzssOutputStream(new LzhHuffmanEncoder(out, method.getThreshold()),
                                               method.getDictionarySize(),
                                               method.getMatchSize(),
                                               method.getThreshold());
        } else {
            frontStream = out;
        }
        writeHeader(entry);
        crc.reset();
    }

    /**
     * wb_ށB
     * @param os OutputStream
     * @param entry LzhEntry
     * @throws IOException o̓G[ꍇ
     */
    public void writeHeader(LzhEntry entry) throws IOException {
        header.write(out, entry);
    }

    /**
     * wb_ށB
     * @param entry LzhEntry
     * @param os OutputStream
     * @throws IOException o̓G[ꍇ
     */
    public void writeHeader(LzhEntry entry, OutputStream os) throws IOException {
        header.write(os, entry);
    }

    /* @see jp.sourceforge.armadillo.io.ArchiveOutputStream#write(int) */
    public void write(int b) throws IOException {
        super.write(b);
        crc.update(b);
    }

    /* @see java.io.FilterOutputStream#write(byte[]) */
    public void write(byte[] b) throws IOException {
        super.write(b);
        crc.update(b, 0, b.length);
    }

    /* @see jp.sourceforge.armadillo.io.ArchiveOutputStream#write(byte[], int, int) */
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        crc.update(b, off, len);
    }

    /**
     * CRCl̎擾B
     * @return CRCl
     */
    public short getCrc() {
        return crc.getShortValue();
    }

    /**
     * GgB
     * @throws IOException o̓G[ꍇ
     */
    public void closeEntry() throws IOException {
        frontStream.flush();
        if (frontStream != out) {
            frontStream.close();
        }
        frontStream = out;
    }

    /* @see jp.sourceforge.armadillo.io.ArchiveOutputStream#close() */
    public void close() throws IOException {
        try {
            flush();
            super.write(0); // end of archive
            super.flush();
        } finally {
            header = null;
            super.close();
        }
    }

}
