package jp.sourceforge.armadillo.tar;

import java.io.*;
import java.util.*;

/**
 * TAR`A[JCũwb_B
 * 
 * <h3>wb_̎dlɂ</h3>
 * <p>݂̃o[Wł́Austar`̂݃T|[gĂB</p>
 * <p>ɋLڂẮAȎdlł͂ȂƂɒӁB</p>
 * 
 * <h3>ustar`</h3>
 * <p>f[^܂߂āA1ubN(512oCg)Pʂŋ؂Bwb_͕KubN̐擪n܂B
 * TCY1ȏ̏ꍇ́Awb_̎̃ubNf[^ƂȂBfBNgȂǂ̏ꍇ͎̃wb_ƂȂB</p>
 * <p>l͐lƂċL^B̏I[Null(<code>0x00</code>)B
 * GR[fBÓAftHgł͕WITar̂悤ASCII`(͈͊OLN^'_'+8iŕ\)ƂĂB
 * Zbgw肳ꂽꍇ́A̕ZbgœǂݏB</p>
 * <p>100oCg𒴂GgipXjꍇ́AGgi[邽߂̃Ggݒ肳B
 * ̎dlɂẮAł͊B</p>
 */
public final class TarHeader {

    private static final int BLOCK_SIZE = 512;

    private byte[] bytes;
    private int position;

    /**
     * TarHeader̐B
     */
    public TarHeader() {
        this.bytes = new byte[BLOCK_SIZE];
        this.position = 0;
    }

    /**
     * wb_ǂݎB
     * @param is ǂݎ茳
     * @return TarEntry
     * @throws IOException wb_ɓǂݎȂꍇ
     */
    public TarEntry read(InputStream is) throws IOException {
        reset();
        int readLength = read(is, bytes);
        if (readLength != BLOCK_SIZE) {
            throw new IOException("bad header: size=" + readLength);
        }
        if (bytes[0] == 0x00 && isEmptyBlock()) {
            if (is.read(bytes) == BLOCK_SIZE && isEmptyBlock()) {
                return null;
            }
            throw new IOException("bad end-of-archive");
        }
        try {
            TarEntry entry = new TarEntry();
            clipNameField(entry, 100);
            entry.mode = clipAsInt(8);
            entry.uid = clipAsInt(8);
            entry.gid = clipAsInt(8);
            entry.size = clipAsLong(12);
            entry.timeT = (int)(clipAsLong(12) & 0xFFFFFFFFL);
            entry.chksum = clipAsInt(8);
            entry.typeFlag = (char)bytes[position++];
            entry.linkName = clip(100);
            entry.magic = clip(6);
            entry.version = clip(2);
            entry.uname = clip(32);
            entry.gname = clip(32);
            entry.devmajor = clip(8);
            entry.devminor = clip(8);
            entry.prefix = clip(155);
            if (entry.getTypeFlag() == 'L') {
                // LongLink support
                readLength = read(is, bytes);
                assert readLength == BLOCK_SIZE;
                position = 0;
                TarEntry tmp = new TarEntry();
                clipNameField(tmp, BLOCK_SIZE);
                entry = read(is);
                entry.name = tmp.name;
                entry.nameAsBytes = tmp.nameAsBytes;
            }
            return entry;
        } catch (RuntimeException ex) {
            IOException exception = new IOException("bad header at " + position);
            exception.initCause(ex);
            throw exception;
        }
    }

    /**
     * obt@܂邩EOFɂȂ܂ŌJԂǂݍށB
     * @param is InputStream
     * @param bytes obt@
     * @return ǂݍ񂾃oCg
     * @throws IOException o̓G[ꍇ 
     */
    private static int read(InputStream is, byte[] bytes) throws IOException {
        int readLength = 0;
        int offset = 0;
        while (readLength < BLOCK_SIZE) {
            int read = is.read(bytes, offset, BLOCK_SIZE - readLength);
            // read == 0 肦
            if (read <= 0) {
                break;
            }
            offset += read;
            readLength += read;
        }
        return readLength;
    }

    /**
     * wb_ށB
     * @param os ݐ
     * @param entry TarEntry
     * @throws IOException wb_ɏ߂Ȃꍇ
     */
    public void write(OutputStream os, TarEntry entry) throws IOException {
        try {
            reset();
            if (entry.nameAsBytes == null) {
                patch(entry.name, 100);
            } else {
                patch(entry.nameAsBytes, 100);
            }
            patch(entry.mode, 8);
            patch(entry.uid, 8);
            patch(entry.gid, 8);
            patch(entry.size, 12);
            patch(entry.timeT, 12);
            patch("        ", 8);
            patch(String.valueOf(entry.typeFlag), 1);
            patch(entry.linkName, 100);
            patch(entry.magic, 6);
            patch(entry.version, 2);
            patch(entry.uname, 32);
            patch(entry.gname, 32);
            patch(entry.devmajor, 8);
            patch(entry.devminor, 8);
            patch(entry.prefix, 155);
            int checksum = 0;
            for (int i = 0; i < bytes.length; i++) {
                checksum += (bytes[i] & 0xFF);
            }
            position = 148;
            patch(checksum, 6);
            entry.setChksum(checksum);
            os.write(bytes);
        } catch (RuntimeException ex) {
            IOException exception = new IOException("bad header at " + position);
            exception.initCause(ex);
            throw exception;
        }
    }

    /**
     * END-OF-ARCHIVEށB
     * @param os OutputStream
     * @throws IOException o̓G[ꍇ 
     */
    public void writeEndOfArchive(OutputStream os) throws IOException {
        reset();
        os.write(bytes);
        os.write(bytes);
        os.flush();
    }

    /**
     * ZbgB
     */
    public void reset() {
        position = 0;
        Arrays.fill(bytes, (byte)0);
    }

    /**
     * GgtB[h؂oB
     * @param entry TarEntry
     * @param length 
     */
    private void clipNameField(TarEntry entry, int length) {
        byte[] nameAsBytes = new byte[length];
        System.arraycopy(bytes, position, nameAsBytes, 0, length);
        entry.name = clip(length);
        entry.nameAsBytes = nameAsBytes;
    }

    /**
     * f[^؂oB
     * @param length 
     * @return ؂of[^
     */
    private String clip(int length) {
        assert length <= BLOCK_SIZE - position;
        int p = position;
        position += length;
        int availableLength = 0;
        for (int i = 0; i < length; i++) {
            if (bytes[p + i] == 0x00) {
                break;
            }
            ++availableLength;
        }
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < availableLength; i++) {
            byte b = bytes[p + i];
            if ((b & 0x80) == 0x80) {
                buffer.append('\\');
                buffer.append(Integer.toOctalString(b & 0xFF));
            } else {
                buffer.append((char)b);
            }
        }
        return buffer.toString();
    }

    /**
     * f[^<code>int</code>lƂĐ؂oB
     * @param length 
     * @return ؂of[^
     */
    private int clipAsInt(int length) {
        return Integer.parseInt(clipAsNumberString(length), 8);
    }

    /**
     * f[^<code>long</code>lƂĐ؂oB
     * @param length 
     * @return ؂of[^
     */
    private long clipAsLong(int length) {
        return Long.parseLong(clipAsNumberString(length), 8);
    }

    /**
     * f[^𐔒lƂĐ؂oB
     * @param length 
     * @return ؂of[^
     */
    private String clipAsNumberString(int length) {
        assert length <= BLOCK_SIZE - position;
        int p = position;
        position += length;
        int i = 0;
        for (; i < length; i++) {
            byte b = bytes[p + i];
            if (b == 0x00) {
                break;
            }
            assert b >= 0x30 && b <= 0x39;
        }
        String s = new String(bytes, p, i);
        return s.trim();
    }

    /**
     * f[^pB
     * @param value l
     * @param length 
     * @return ۂɓ\t
     */
    private int patch(String value, int length) {
        int p = position;
        position += length;
        byte[] data;
        if (value == null) {
            data = new byte[0];
        } else {
            data = value.getBytes();
        }
        return patch(data, p);
    }

    /**
     * f[^pB
     * @param value l
     * @param length 
     * @return ۂɓ\t
     */
    private int patch(byte[] value, int length) {
        System.arraycopy(value, 0, bytes, length, value.length);
        return value.length;
    }

    /**
     * f[^pB
     * @param value l
     * @param length 
     * @return ۂɓ\t
     */
    private int patch(int value, int length) {
        String s = padZero(Integer.toOctalString(value), length - 1);
        return patch(s + (char)0, length);
    }

    /**
     * f[^pB
     * @param value l
     * @param length 
     * @return ۂɓ\t
     */
    private int patch(long value, int length) {
        String s = padZero(Long.toOctalString(value), length - 1);
        return patch(s + (char)0, length);
    }

    /**
     * [()߂B
     * w肵̒ȏ̏ꍇ͕̂܂ܕԂB
     * @param value l
     * @param length 
     * @return [߂ꂽl
     */
    private String padZero(String value, int length) {
        int valueLength = value.length();
        if (valueLength >= length) {
            return value;
        }
        char[] buffer = new char[length];
        int p = length - valueLength;
        for (int i = 0; i < p; i++) {
            buffer[i] = '0';
        }
        for (int i = p; i < length; i++) {
            buffer[i] = value.charAt(i - p);
        }
        return String.valueOf(buffer);
    }

    /**
     * ubNǂׂB
     * @return ubN̏ꍇ <code>true</code>AłȂ <code>false</code> 
     */
    private boolean isEmptyBlock() {
        for (int i = 0; i < bytes.length; i++) {
            if (bytes[i] != 0x00) {
                return false;
            }
        }
        return true;
    }

    /**
     * XLbvTCY̎擾B
     * ubN̗]蕔̃XLbvɎgpB
     * @param size TCY
     * @return XLbvTCY
     */
    static long getSkipSize(long size) {
        if (size == 0 || size == BLOCK_SIZE || size % BLOCK_SIZE == 0) {
            return 0;
        } else {
            return BLOCK_SIZE - ((size > BLOCK_SIZE) ? size % BLOCK_SIZE : size);
        }
    }

}
