package jp.sourceforge.armadillo.tar;

import java.io.*;

import jp.sourceforge.armadillo.io.*;

/**
 * TAR`A[JCu̓̓Xg[B
 */
public final class TarInputStream extends ArchiveInputStream {

    private TarHeader header;
    private long skipSize;

    /**
     * TarInputStream̐B
     * @param is InputStream
     */
    public TarInputStream(InputStream is) {
        super(is);
        this.header = new TarHeader();
        this.skipSize = 0;
        frontStream = is;
    }

    /**
     * ̃Gg擾B
     * @return TarEntry ̃Ggꍇ <code>null</code>
     * @throws IOException o̓G[ꍇ
     */
    public TarEntry getNextEntry() throws IOException {
        ensureOpen();
        if (remaining + skipSize > 0) {
            remaining += skipSize;
            while (remaining > 0) {
                long skipped = in.skip(remaining);
                remaining -= skipped;
            }
        }
        remaining = 0;
        skipSize = 0;
        TarEntry entry = header.read(in);
        if (entry == null) {
            return null;
        }
        long size = entry.getSize();
        remaining = size;
        skipSize = TarHeader.getSkipSize(size);
        return entry;
    }

    /* @see jp.sourceforge.armadillo.io.ArchiveInputStream#close() */
    public void close() throws IOException {
        header = null;
        super.close();
    }

}
