package jp.sourceforge.armadillo.tar;

import java.io.*;

import jp.sourceforge.armadillo.io.*;

/**
 * TAR`A[JCȕo̓Xg[B
 */
public final class TarOutputStream extends ArchiveOutputStream {

    private TarHeader header;
    private TarEntry nextEntry;

    /**
     * TarOutputStream̐B
     * @param os o͐
     */
    public TarOutputStream(OutputStream os) {
        super(os);
        this.header = new TarHeader();
        frontStream = os;
    }

    /**
     * GgǉB
     * wb_͑ɏ܂B
     * @param entry TarEntry
     * @throws IOException Gg݂̏Ɏsꍇ
     */
    public void putNextEntry(TarEntry entry) throws IOException {
        ensureOpen();
        nextEntry = entry;
        header.write(this, entry);
        written = 0;
    }

    /**
     * ݂̃GgIB
     * @throws IOException Gg݂̏Ɏsꍇ
     */
    public void closeEntry() throws IOException {
        ensureOpen();
        int skipSize = (int)TarHeader.getSkipSize(nextEntry.getSize());
        write(new byte[skipSize]);
        flush();
        nextEntry = null;
    }

    /* @see jp.sourceforge.armadillo.io.ArchiveOutputStream#close() */
    public void close() throws IOException {
        try {
            header.writeEndOfArchive(this);
        } finally {
            try {
                super.close();
            } finally {
                header = null;
                nextEntry = null;
            }
        }
    }

}
