package jp.sourceforge.armadillo.zip;

/**
 * ZIP`A[JCũGgB
 */
public final class ZipEntry {

    /**
     * <code>STORED</code>
     */
    public static final int STORED = 0;

    /**
     * <code>DEFLATED</code>
     */
    public static final int DEFLATED = 8;

    String name;
    byte[] nameAsBytes;
    short version;
    short option;
    int method;
    int fTime;
    long crc;
    long compressedSize;
    long size;
    int position;

    /**
     * ZipEntry̐B
     */
    public ZipEntry() {
        this("");
    }

    /**
     * ZipEntry̐B
     * @param name name
     */
    public ZipEntry(String name) {
        this.name = name;
        this.version = 10;
        this.option = 0;
        this.method = DEFLATED;
        this.fTime = 0;
        this.crc = -1;
        this.compressedSize = -1;
        this.size = -1;
    }

    /**
     * ZipEntry̐B
     * @param entry ZipEntry
     */
    public ZipEntry(ZipEntry entry) {
        this.name = entry.name;
        this.version = entry.version;
        this.option = entry.option;
        this.method = entry.method;
        this.fTime = entry.fTime;
        this.crc = entry.crc;
        this.compressedSize = entry.compressedSize;
        this.size = entry.size;
    }

    /**
     * fBNg̃Ggǂ𒲂ׂB
     * @return fBNgȂ <code>true</code>AłȂ <code>false</code>
     */
    public boolean isDirectory() {
        return name.endsWith("/");
    }

    /**
     * EXTwb_ǂ𒲂ׂB
     * @return EXTwb_ꍇ <code>true</code>AłȂ <code>false</code>
     */
    public boolean hasEXT() {
        return (option & 8) == 8;
    }

    /**
     * name̎擾B
     * @return name
     */
    public String getName() {
        return name;
    }

    /**
     * name̐ݒB
     * @param name name
     */
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    /**
     * GgbytezƂĎ擾B
     * Gg̃GR[fBOsv̏ꍇ͎gpȂB
     * @return bytez̃Gg
     */
    public byte[] getNameAsBytes() {
        return nameAsBytes;
    }

    /**
     * GgbytezƂĐݒ肷B
     * Gg̃GR[fBOsv̏ꍇ͎gpȂB
     * @param nameAsBytes bytez̃Gg
     */
    public void setNameAsBytes(byte[] nameAsBytes) {
        this.nameAsBytes = nameAsBytes;
    }

    /**
     * version̎擾B
     * @return version
     */
    public short getVersion() {
        return version;
    }

    /**
     * version̐ݒB
     * @param version version
     */
    public void setVersion(short version) {
        this.version = version;
    }

    /**
     * option̎擾B
     * @return option
     */
    public short getOption() {
        return option;
    }

    /**
     * option̐ݒB
     * @param option option
     */
    public void setOption(short option) {
        this.option = option;
    }

    /**
     * method̎擾B
     * @return method
     */
    public int getMethod() {
        return method;
    }

    /**
     * method̐ݒB
     * @param method method
     */
    public void setMethod(int method) {
        this.method = method;
    }

    /**
     * fTime̎擾B
     * @return fTime
     */
    public int getFTime() {
        return fTime;
    }

    /**
     * fTime̐ݒB
     * @param fTime fTime
     */
    public void setFTime(int fTime) {
        this.fTime = fTime;
    }

    /**
     * crc̎擾B
     * @return crc
     */
    public long getCrc() {
        return crc;
    }

    /**
     * crc̐ݒB
     * @param crc crc
     */
    public void setCrc(long crc) {
        this.crc = crc;
    }

    /**
     * compressedSize̎擾B
     * @return compressedSize
     */
    public long getCompressedSize() {
        return compressedSize;
    }

    /**
     * compressedSize̐ݒB
     * @param compressedSize compressedSize
     */
    public void setCompressedSize(long compressedSize) {
        this.compressedSize = compressedSize;
    }

    /**
     * size̎擾B
     * @return size
     */
    public long getSize() {
        return size;
    }

    /**
     * size̐ݒB
     * @param size size
     */
    public void setSize(long size) {
        this.size = size;
    }

}
