/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jp.sfjp.armadillo.Logger;
import jp.sfjp.armadillo.ProgressNotifier;
import jp.sfjp.armadillo.archive.ArchiveCreator;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.ArchiveExtractor;
import jp.sfjp.armadillo.archive.ArchiveType;
import jp.sfjp.armadillo.archive.cab.CabArchiveCreator;
import jp.sfjp.armadillo.archive.cab.CabArchiveExtractor;
import jp.sfjp.armadillo.archive.lzh.LzhFile;
import jp.sfjp.armadillo.archive.tar.TarArchiveCreator;
import jp.sfjp.armadillo.archive.tar.TarArchiveExtractor;
import jp.sfjp.armadillo.archive.zip.ZipFile;
import jp.sfjp.armadillo.file.Find;
import jp.sfjp.armadillo.file.FindAction;
import jp.sfjp.armadillo.io.VolumetricOutputStream;

public final class ArmadilloCommands {
    private static Logger log = Logger.getLogger(ArmadilloCommands.class);

    private ArmadilloCommands() {
    }

    public static String getVersionString() {
        return ArmadilloCommands.getVersionString(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersionString(boolean bl) {
        try {
            InputStream inputStream = ArmadilloCommands.class.getResourceAsStream("version");
            if (inputStream == null) return "";
            try {
                Scanner scanner = new Scanner(inputStream);
                if (!scanner.hasNextLine()) return "";
                String string = scanner.nextLine();
                return string;
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            if (!bl) return "";
            throw new IllegalStateException(exception);
        }
    }

    public static void createArchive(File file, File file2) throws IOException {
        ArmadilloCommands.createArchive(file, file2, ProgressNotifier.NullObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createArchive(File file, File file2, ProgressNotifier progressNotifier) throws IOException {
        File file3 = ArmadilloCommands.getAlternativeFileIfExists(file2);
        ArchiveType archiveType = ArchiveType.of(file3.getName());
        List<File> list = ArmadilloCommands.getAllChildrenFile(file);
        ArchiveCreator archiveCreator = ArmadilloCommands.getArchiveCreator(file3, archiveType);
        try {
            for (File file4 : list) {
                String string = ArmadilloCommands.getRelativePath(file, file4);
                if (string.length() == 0) continue;
                ArchiveEntry archiveEntry = archiveCreator.newEntry(string);
                long l = file4.length();
                archiveEntry.setSize(l);
                archiveEntry.setLastModified(file4.lastModified());
                archiveCreator.addEntry(archiveEntry, file4);
                if (l <= 0L) continue;
                progressNotifier.notifyProgress(l);
            }
        }
        finally {
            archiveCreator.close();
        }
    }

    public static void extractAll(File file) throws IOException {
        ArmadilloCommands.extractAll(file, ProgressNotifier.NullObject);
    }

    public static void extractAll(File file, File file2) throws IOException {
        ArmadilloCommands.extractAll(file, file2, ProgressNotifier.NullObject);
    }

    public static void extractAll(File file, ProgressNotifier progressNotifier) throws IOException {
        ArmadilloCommands.extractAll(file, ArmadilloCommands.getAlternativeFileIfExists(ArmadilloCommands.getDestinationDirectory(file)), progressNotifier);
    }

    public static void extractAll(File file, File file2, ProgressNotifier progressNotifier) throws IOException {
        Set<String> set = Collections.emptySet();
        ArmadilloCommands.extract(file, file2, set, progressNotifier);
    }

    public static void extract(File file, Set<String> set, ProgressNotifier progressNotifier) throws IOException {
        ArmadilloCommands.extract(file, ArmadilloCommands.getAlternativeFileIfExists(ArmadilloCommands.getDestinationDirectory(file)), set, progressNotifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(File file, File file2, Set<String> set, ProgressNotifier progressNotifier) throws IOException {
        if (file2.exists()) {
            throw new IOException("the directory already exists: " + file2);
        }
        boolean bl = set.isEmpty();
        int n = set.size();
        ArchiveType archiveType = ArchiveType.of(file.getName());
        HashSet<ArchiveEntry> hashSet = new HashSet<ArchiveEntry>();
        ArchiveExtractor archiveExtractor = ArmadilloCommands.getArchiveExtractor(file, archiveType);
        try {
            File file3;
            Object object;
            assert (!file2.exists());
            if (!file2.mkdirs()) {
                throw new IllegalStateException("failed to mkdirs");
            }
            while ((object = archiveExtractor.nextEntry()) != ArchiveEntry.NULL) {
                long l;
                if (((ArchiveEntry)object).isDirectory()) {
                    hashSet.add((ArchiveEntry)object);
                }
                if (!bl && !set.contains(((ArchiveEntry)object).getName())) continue;
                if (!bl) {
                    --n;
                }
                File object2 = ArmadilloCommands.getRelativeFile(file2, (ArchiveEntry)object);
                if (((ArchiveEntry)object).isDirectory()) {
                    if (object2.exists()) continue;
                    object2.mkdirs();
                    continue;
                }
                if (object2.exists()) {
                    throw new IOException("file '" + object2 + "' already exists");
                }
                file3 = object2.getParentFile();
                if (!file3.exists() && !file3.mkdirs()) {
                    throw new IOException("can't mkdir '" + file3 + "'");
                }
                long l2 = ((ArchiveEntry)object).getCompressedSize() > 0L ? ((ArchiveEntry)object).getCompressedSize() : (long)((float)((ArchiveEntry)object).getSize() * 0.18f);
                long l3 = (long)((float)l2 * 0.3f);
                long l4 = l2 - l3;
                assert (l3 + l4 == l2);
                progressNotifier.notifyProgress(l3);
                if (object2.exists()) {
                    throw new IOException("file '" + object2 + "' already exists");
                }
                FileOutputStream fileOutputStream = new FileOutputStream(object2);
                try {
                    l = archiveExtractor.extract(fileOutputStream);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("illegal state", exception);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
                assert (l == ((ArchiveEntry)object).getSize()) : String.format("%s: written=%d, entry=%d", ((ArchiveEntry)object).getName(), l, ((ArchiveEntry)object).getSize());
                object2.setLastModified(((ArchiveEntry)object).getLastModified());
                progressNotifier.notifyProgress(l4);
                if (bl || n > 0) continue;
                break;
            }
            progressNotifier.notifyFinished();
            for (ArchiveEntry archiveEntry : hashSet) {
                file3 = new File(file2, archiveEntry.getName());
                if (!file3.exists()) continue;
                file3.setLastModified(archiveEntry.getLastModified());
            }
        }
        finally {
            archiveExtractor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validate(File file) throws IOException {
        ArchiveType archiveType = ArchiveType.of(file.getName());
        ArchiveExtractor archiveExtractor = ArmadilloCommands.getArchiveExtractor(file, archiveType);
        try {
            ArchiveEntry archiveEntry;
            while ((archiveEntry = archiveExtractor.nextEntry()) != ArchiveEntry.NULL) {
                assert (archiveEntry != null) : "return null entry: extractor=" + archiveExtractor.getClass().getSimpleName();
                if (archiveEntry.isDirectory()) continue;
                VolumetricOutputStream volumetricOutputStream = new VolumetricOutputStream();
                try {
                    if (archiveExtractor.extract(volumetricOutputStream) == archiveEntry.getSize()) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    volumetricOutputStream.close();
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            log.error(exception);
            boolean bl = false;
            return bl;
        }
        finally {
            archiveExtractor.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ArchiveEntry> extractArchiveEntries(File file, ArchiveType archiveType) throws IOException {
        ArrayList<ArchiveEntry> arrayList = new ArrayList<ArchiveEntry>();
        ArchiveExtractor archiveExtractor = ArmadilloCommands.getArchiveExtractor(file, archiveType);
        try {
            ArchiveEntry archiveEntry;
            while ((archiveEntry = archiveExtractor.nextEntry()) != ArchiveEntry.NULL) {
                arrayList.add(archiveEntry);
            }
        }
        finally {
            archiveExtractor.close();
        }
        return arrayList;
    }

    public static long transferAll(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            assert (n != 0) : "Read Zero";
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        outputStream.flush();
        return l;
    }

    public static String getRelativePath(File file, File file2) throws IOException {
        String string = file2.getCanonicalFile().getAbsolutePath();
        String string2 = file.getCanonicalFile().getAbsolutePath();
        if (string2.equals(string)) {
            return "";
        }
        if (!string.startsWith(string2)) {
            throw new IllegalStateException(String.format("not relative: dir=%s, f=%s", file, file2));
        }
        int n = string2.length() + (string2.endsWith("/") ? 0 : 1);
        String string3 = string.substring(n).replace('\\', '/');
        if (file2.isDirectory() && !string.endsWith("/")) {
            return string3 + "/";
        }
        return string3;
    }

    public static File getRelativeFile(File file, ArchiveEntry archiveEntry) {
        String string = archiveEntry.getName();
        if (string.startsWith("/")) {
            return new File(file, string);
        }
        if (string.matches("(?i)[A-Z]\\:[\\\\/].*")) {
            return new File(file, string.substring(2));
        }
        return new File(file, string);
    }

    public static List<File> getAllChildrenFile(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("file is not dir: " + file);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArmadilloCommands.getAllChildrenFile(arrayList, file);
        return arrayList;
    }

    private static void getAllChildrenFile(List<File> list, File file) {
        File[] fileArray;
        list.add(file);
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                ArmadilloCommands.getAllChildrenFile(list, file2);
            }
        }
    }

    public static long getTotalSize(File file) {
        TotalFileSizeFindAction totalFileSizeFindAction = new TotalFileSizeFindAction();
        Find.find(file, totalFileSizeFindAction);
        return totalFileSizeFindAction.totalSize;
    }

    public static File getDestinationDirectory(File file) {
        return ArmadilloCommands.getAlternativeFileIfExists(new File(file.getPath() + ".tmp"));
    }

    public static File getAlternativeFileIfExists(File file) {
        int n;
        String string;
        String string2;
        if (!file.exists()) {
            return file;
        }
        File file2 = file.getParentFile();
        String string3 = file.getName();
        if (file.isDirectory()) {
            string2 = string3;
            string = "";
        } else {
            n = string3.indexOf(46);
            if (n == 0) {
                throw new IllegalArgumentException("dot file not supported at getAlternativeFileIfExists");
            }
            if (n > 0) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = "";
            }
        }
        for (n = 1; n <= 1000; ++n) {
            String string4 = String.format("%s(%d).%s", string2, n, string);
            File file3 = new File(file2, string4);
            if (file3.exists()) continue;
            return file3;
        }
        throw new RuntimeException("over 100 times to try to resolve alternative file.");
    }

    public static ArchiveCreator getArchiveCreator(File file, ArchiveType archiveType) throws IOException {
        switch (archiveType) {
            case TAR: {
                return new TarArchiveCreator(new BufferedOutputStream(new FileOutputStream(file)));
            }
            case TARGZ: {
                return new TarArchiveCreator(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
            }
            case TARZ: 
            case TARBZ2: 
            case TARXZ: {
                return new TarArchiveCreator(ArmadilloCommands.getOutputStream(file, archiveType));
            }
            case ZIP: {
                return new ZipFile(file, true);
            }
            case LZH: {
                return new LzhFile(file, true);
            }
            case CAB: {
                return new CabArchiveCreator(new BufferedOutputStream(new FileOutputStream(file)));
            }
        }
        throw new IllegalStateException("File: " + file + ", ArchiverType: " + (Object)((Object)archiveType));
    }

    private static OutputStream getOutputStream(File file, ArchiveType archiveType) throws IOException {
        try {
            String string = System.getProperty("plugin.stream.o." + (Object)((Object)archiveType), "");
            if (string.length() == 0) {
                throw new UnsupportedOperationException("File: " + file + ", ArchiverType: " + (Object)((Object)archiveType));
            }
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(InputStream.class);
            return (OutputStream)constructor.newInstance(new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("File: " + file + ", ArchiverType: " + (Object)((Object)archiveType), exception);
        }
    }

    public static ArchiveExtractor getArchiveExtractor(File file, ArchiveType archiveType) throws IOException {
        switch (archiveType) {
            case TAR: {
                return new TarArchiveExtractor(new BufferedInputStream(new FileInputStream(file)));
            }
            case TARGZ: {
                return new TarArchiveExtractor(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))));
            }
            case TARZ: 
            case TARBZ2: 
            case TARXZ: {
                return new TarArchiveExtractor(new BufferedInputStream(ArmadilloCommands.getInputStream(file, archiveType)));
            }
            case ZIP: {
                return new ZipFile(file, true);
            }
            case LZH: {
                return new LzhFile(file, true);
            }
            case CAB: {
                return new CabArchiveExtractor(new BufferedInputStream(new FileInputStream(file)));
            }
        }
        throw new IllegalStateException("File: " + file + ", ArchiverType: " + (Object)((Object)archiveType));
    }

    private static InputStream getInputStream(File file, ArchiveType archiveType) throws IOException {
        try {
            String string = System.getProperty("plugin.stream.i." + (Object)((Object)archiveType), "");
            if (string.length() == 0) {
                throw new UnsupportedOperationException("File: " + file + ", ArchiverType: " + (Object)((Object)archiveType));
            }
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(InputStream.class);
            return (InputStream)constructor.newInstance(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("File: " + file + ", ArchiverType: " + (Object)((Object)archiveType), exception);
        }
    }

    static final class TotalFileSizeFindAction
    implements FindAction {
        long totalSize;

        TotalFileSizeFindAction() {
        }

        @Override
        public void act(File file) {
            this.totalSize += file.length();
        }
    }
}

