/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import jp.sfjp.armadillo.archive.ArchiveEntryInterface;

public abstract class ArchiveEntry
implements ArchiveEntryInterface {
    public static final ArchiveEntry NULL = new NullArchiveEntry();
    private boolean added;
    private String name;
    private byte[] nameb;
    private boolean initialized;

    protected ArchiveEntry(boolean bl) {
        this.initialized = bl;
    }

    public static ArchiveEntry orNull(ArchiveEntry archiveEntry) {
        return archiveEntry == null ? NULL : archiveEntry;
    }

    public ArchiveEntry copyFrom(ArchiveEntry archiveEntry) {
        ArchiveEntry.copyAtoB(archiveEntry, this);
        return archiveEntry;
    }

    public ArchiveEntry copyTo(ArchiveEntry archiveEntry) {
        ArchiveEntry.copyAtoB(this, archiveEntry);
        return archiveEntry;
    }

    private static void copyAtoB(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) {
        archiveEntry2.name = archiveEntry.name;
        archiveEntry2.nameb = archiveEntry.nameb;
        archiveEntry2.initialized = archiveEntry.initialized;
        archiveEntry2.setSize(archiveEntry.getSize());
        archiveEntry2.setCompressedSize(archiveEntry.getCompressedSize());
        archiveEntry2.setLastModified(archiveEntry.getLastModified());
    }

    public boolean isNull() {
        return this == NULL;
    }

    public boolean isAdded() {
        return this.added;
    }

    @Override
    public void setAdded(boolean bl) {
        this.added = bl;
    }

    public final String name() {
        if (this.name == null) {
            if (this.nameb == null) {
                throw new IllegalStateException("not initialized: " + this.getClass());
            }
            this.name = new String(this.nameb);
        }
        return this.name;
    }

    @Override
    public final String getName() {
        return this.name();
    }

    public final byte[] getNameAsBytes() {
        if (this.nameb == null) {
            if (this.name == null) {
                throw new IllegalStateException("not initialized: " + this.getClass());
            }
            this.nameb = this.name.getBytes();
        }
        return Arrays.copyOf(this.nameb, this.nameb.length);
    }

    public final byte[] getNameAsBytes(Charset charset) {
        if (this.nameb == null) {
            this.nameb = this.name.getBytes(charset);
        }
        return Arrays.copyOf(this.nameb, this.nameb.length);
    }

    public final void setName(String string) {
        this.name = string;
        this.nameb = null;
        this.initialized = true;
    }

    public final void setName(String string, Charset charset) {
        this.name = string;
        this.nameb = string.getBytes(charset);
        this.initialized = true;
    }

    public final void setName(byte[] byArray) {
        this.name = null;
        this.nameb = Arrays.copyOf(byArray, byArray.length);
        this.initialized = true;
    }

    public final boolean equalsName(ArchiveEntry archiveEntry) {
        return Arrays.equals(this.getNameAsBytes(), archiveEntry.getNameAsBytes());
    }

    public final void setFileInfo(File file) {
        assert (this.isDirectory() == file.isDirectory());
        this.setSize(file.length());
        this.setLastModified(file.lastModified());
    }

    @Override
    public boolean isDirectory() {
        if (this.initialized) {
            return this.getName().endsWith("/");
        }
        return false;
    }

    @Override
    public long getSize() {
        throw new UnsupportedOperationException("ArchiveEntry#getSize");
    }

    @Override
    public void setSize(long l) {
        throw new UnsupportedOperationException("ArchiveEntry#setSize");
    }

    @Override
    public long getCompressedSize() {
        throw new UnsupportedOperationException("ArchiveEntry#getCompressedSize");
    }

    @Override
    public void setCompressedSize(long l) {
        throw new UnsupportedOperationException("ArchiveEntry#setCompressedSize");
    }

    @Override
    public long getLastModified() {
        throw new UnsupportedOperationException("ArchiveEntry#getLastModified");
    }

    @Override
    public void setLastModified(long l) {
        throw new UnsupportedOperationException("ArchiveEntry#setLastModified");
    }

    public String getMethodName() {
        return "";
    }

    public String toString() {
        return String.format("%s:%s", this.getClass().getSimpleName(), this.getName());
    }

    private static final class NullArchiveEntry
    extends ArchiveEntry {
        public NullArchiveEntry() {
            super(false);
        }
    }
}

