/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import jp.sfjp.armadillo.archive.ArchiveCreator;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.ArchiveExtractor;

public abstract class ArchiveFile
implements Iterable<ArchiveEntry>,
ArchiveCreator,
ArchiveExtractor {
    protected long currentPosition = 0L;
    protected boolean opened = false;
    private boolean closed = false;

    protected ArchiveFile() {
    }

    @Override
    public Iterator<ArchiveEntry> iterator() {
        return new Iterator<ArchiveEntry>(){
            boolean first = true;
            ArchiveEntry entry = null;

            @Override
            public boolean hasNext() {
                try {
                    if (this.first) {
                        ArchiveFile.this.reset();
                        this.first = false;
                    }
                    this.entry = ArchiveFile.this.nextEntry();
                }
                catch (IOException iOException) {
                    this.handleException(iOException);
                }
                assert (this.entry != null);
                return this.entry != ArchiveEntry.NULL;
            }

            @Override
            public ArchiveEntry next() {
                return this.entry;
            }

            @Override
            public void remove() {
                try {
                    ArchiveFile.this.removeEntry(this.entry);
                }
                catch (IOException iOException) {
                    this.handleException(iOException);
                }
            }

            void handleException(Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        assert (archiveEntry.isDirectory() == file.isDirectory());
        if (archiveEntry.isDirectory()) {
            this.addEntry(archiveEntry, null, 0L);
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.addEntry(archiveEntry, fileInputStream, file.length());
            }
            finally {
                fileInputStream.close();
            }
        }
    }

    @Override
    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        throw new UnsupportedOperationException("ArchiveFile#addEntry");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        assert (archiveEntry.isDirectory() == file.isDirectory());
        if (archiveEntry.isDirectory()) {
            this.updateEntry(archiveEntry, null, 0L);
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.updateEntry(archiveEntry, fileInputStream, file.length());
            }
            finally {
                fileInputStream.close();
            }
        }
    }

    public void updateEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        this.removeEntry(archiveEntry);
        this.addEntry(archiveEntry, inputStream, l);
    }

    public void removeEntry(ArchiveEntry archiveEntry) throws IOException {
        throw new UnsupportedOperationException("ArchiveFile#removeEntry");
    }

    public boolean seek(ArchiveEntry archiveEntry) throws IOException {
        ArchiveEntry archiveEntry2;
        this.reset();
        while ((archiveEntry2 = this.nextEntry()) != null) {
            if (!archiveEntry2.equalsName(archiveEntry)) continue;
            return true;
        }
        this.reset();
        return false;
    }

    @Override
    public ArchiveEntry nextEntry() throws IOException {
        throw new UnsupportedOperationException("ArchiveFile#nextEntry");
    }

    @Override
    public long extract(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException("ArchiveFile#extract");
    }

    public abstract void open() throws IOException;

    public abstract void reset() throws IOException;

    protected final void ensureOpen() throws IOException {
        if (!this.opened) {
            throw new IOException("file is not opened yet");
        }
        if (this.closed) {
            throw new IOException("file was closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.currentPosition = 0L;
        this.closed = true;
    }
}

