/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ArchiveInputStream
extends FilterInputStream {
    protected InputStream frontStream;
    protected long remaining = 0L;
    private boolean closed = false;

    public ArchiveInputStream(InputStream inputStream) {
        super(inputStream);
    }

    protected final void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.frontStream == null) {
            return super.read();
        }
        if (this.remaining <= 0L) {
            assert (this.remaining == 0L);
            return -1;
        }
        int n = this.frontStream.read();
        if (n == -1) {
            return -1;
        }
        --this.remaining;
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.frontStream == null) {
            return super.read(byArray, n, n2);
        }
        if (this.remaining <= 0L) {
            assert (this.remaining == 0L);
            return -1;
        }
        long l = Math.min((long)n2, this.remaining);
        assert (l <= Integer.MAX_VALUE);
        int n3 = this.frontStream.read(byArray, n, (int)l);
        assert (n3 != 0) : "Read Zero";
        if (n3 >= 0) {
            this.remaining -= (long)n3;
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        this.ensureOpen();
        if (this.frontStream == null) {
            return super.skip(l);
        }
        if (this.remaining <= 0L) {
            assert (this.remaining == 0L);
            return -1L;
        }
        long l2 = this.frontStream.skip(l);
        if (l2 > 0L) {
            this.remaining -= l2;
        }
        return l2;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int n) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.ensureOpen();
        try {
            super.close();
        }
        finally {
            this.frontStream = null;
            this.closed = true;
        }
    }
}

