/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.cab;

import java.io.File;
import jp.sfjp.armadillo.archive.cab.CabCfFolder;
import jp.sfjp.armadillo.archive.cab.CabCompressionType;
import jp.sfjp.armadillo.archive.cab.CabEntry;
import jp.sfjp.armadillo.time.FTime;

public final class CabCfFile
extends CabEntry {
    private static final FTime FTIME = new FTime();
    CabCfFolder folder = new CabCfFolder("./");
    int uncompressedSize = 0;
    int uncompressedOffset = 0;
    short folderIndex = 0;
    short date = 0;
    short time = 0;
    short attributes = (short)32;

    public CabCfFile() {
    }

    public CabCfFile(byte[] byArray) {
        this();
        this.setName(byArray);
    }

    public CabCfFile(String string, File file) {
        this();
        this.setName(string);
        this.setSize(file.length());
        this.setLastModified(file.lastModified());
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public long getSize() {
        return this.uncompressedSize;
    }

    @Override
    public void setSize(long l) {
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("limit=int_max, size=" + l);
        }
        this.uncompressedSize = (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public long getCompressedSize() {
        return -1L;
    }

    @Override
    public void setCompressedSize(long l) {
    }

    @Override
    public long getLastModified() {
        return FTIME.toMillisecond(this.date, this.time);
    }

    @Override
    public void setLastModified(long l) {
        int n = FTIME.int32From(l);
        this.date = (short)(n >> 16 & 0xFFFF);
        this.time = (short)(n & 0xFFFF);
    }

    @Override
    public String getMethodName() {
        return CabCompressionType.of(this.folder.method).toString();
    }
}

