/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.lzh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.ArchiveExtractor;
import jp.sfjp.armadillo.archive.lzh.LzhInputStream;
import jp.sfjp.armadillo.io.IOUtilities;

public final class LzhArchiveExtractor
implements ArchiveExtractor {
    private LzhInputStream is;

    public LzhArchiveExtractor(InputStream inputStream) {
        this.is = new LzhInputStream(inputStream);
    }

    @Override
    public ArchiveEntry nextEntry() throws IOException {
        return ArchiveEntry.orNull(this.is.getNextEntry());
    }

    @Override
    public long extract(OutputStream outputStream) throws IOException {
        return IOUtilities.transferAll(this.is, outputStream);
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

