/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.lzh;

import java.util.zip.Checksum;

public final class LzhChecksum
implements Checksum {
    private final int[] table;
    private final int initial;
    private int value;

    public LzhChecksum() {
        this(40961, 0);
    }

    LzhChecksum(int n, int n2) {
        this.table = LzhChecksum.create(n);
        this.initial = n2;
        this.value = n2;
    }

    static int[] create(int n) {
        int[] nArray = new int[256];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
            for (int j = 0; j < 8; ++j) {
                if ((nArray[i] & 1) != 0) {
                    nArray[i] = nArray[i] >> 1 ^ n;
                    continue;
                }
                int n2 = i;
                nArray[n2] = nArray[n2] >> 1;
            }
        }
        return nArray;
    }

    public short getShortValue() {
        return (short)(this.value & 0xFFFF);
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void reset() {
        this.value = this.initial;
    }

    @Override
    public void update(int n) {
        int n2 = this.value;
        this.value = n2 = n2 >> 8 ^ this.table[(n2 ^ n) & 0xFF];
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3 = this.value;
        for (int i = n; i < n + n2; ++i) {
            n3 = n3 >> 8 ^ this.table[(n3 ^ byArray[i]) & 0xFF];
        }
        this.value = n3;
    }
}

