/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.lzh;

import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.lzh.LzhException;
import jp.sfjp.armadillo.archive.lzh.LzhMethod;
import jp.sfjp.armadillo.time.FTime;
import jp.sfjp.armadillo.time.FileTime;
import jp.sfjp.armadillo.time.TimeConverter;
import jp.sfjp.armadillo.time.TimeT;

public final class LzhEntry
extends ArchiveEntry {
    private static final TimeT TIME_T = new TimeT();
    private static final FTime FTIME = new FTime();
    private static final FileTime FILETIME = new FileTime();
    int headerLength;
    String method;
    long compressedSize;
    long size;
    private int ftime;
    private int timeT;
    private long fileTime;
    byte type;
    final byte headerLevel;
    short crc;
    int checksum;
    int calculatedChecksum;
    byte attribute;
    byte osIdentifier;

    public LzhEntry(int n) {
        super(false);
        this.headerLevel = (byte)n;
        this.method = "-lh5-";
        this.osIdentifier = (byte)74;
    }

    @Override
    public boolean isDirectory() {
        return "-lhd-".equals(this.method);
    }

    public LzhMethod getMethod() throws LzhException {
        if (this.method == null) {
            throw new IllegalStateException("method is null");
        }
        return new LzhMethod(this.method);
    }

    public void setMethod(String string) {
        this.method = string;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long l) {
        this.size = l;
    }

    @Override
    public long getCompressedSize() {
        return this.compressedSize;
    }

    @Override
    public void setCompressedSize(long l) {
        this.compressedSize = l;
    }

    @Override
    public long getLastModified() {
        TimeConverter timeConverter = LzhEntry.getTimeConverter(this.headerLevel);
        if (timeConverter == FTIME) {
            return FTIME.toMilliseconds(this.ftime);
        }
        if (timeConverter == FILETIME) {
            return timeConverter.toMilliseconds(this.fileTime);
        }
        return timeConverter.toMilliseconds(this.timeT);
    }

    @Override
    public void setLastModified(long l) {
        TimeConverter timeConverter = LzhEntry.getTimeConverter(this.headerLevel);
        if (timeConverter == FTIME) {
            this.ftime = FTIME.int32From(l);
        } else if (timeConverter == FILETIME) {
            this.fileTime = timeConverter.int64From(l);
        } else {
            this.timeT = timeConverter.int32From(l);
        }
    }

    @Override
    public String getMethodName() {
        return this.method;
    }

    private static TimeConverter getTimeConverter(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return FTIME;
            }
            case 2: {
                return FILETIME;
            }
        }
        return TIME_T;
    }

    int getFTime() {
        return FTIME.int32From(this.getLastModified());
    }

    void setFtime(short s, short s2) {
        this.ftime = s << 16 | s2 & 0xFFFF;
        this.setLastModified(FTIME.toMilliseconds(this.ftime));
    }

    long getFileTime() {
        return FILETIME.int64From(this.getLastModified());
    }

    void setFileTime(long l) {
        this.fileTime = l;
        this.setLastModified(FILETIME.toMilliseconds(l));
    }

    int getTimeT() {
        return TIME_T.int32From(this.getLastModified());
    }

    void setTimeT(int n) {
        this.timeT = n;
        this.setLastModified(TIME_T.toMilliseconds(n));
    }
}

