/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.lzh;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.ArchiveFile;
import jp.sfjp.armadillo.archive.lzh.LzhArchiveCreator;
import jp.sfjp.armadillo.archive.lzh.LzhChecksum;
import jp.sfjp.armadillo.archive.lzh.LzhEntry;
import jp.sfjp.armadillo.archive.lzh.LzhException;
import jp.sfjp.armadillo.archive.lzh.LzhHeader;
import jp.sfjp.armadillo.archive.lzh.LzhOutputStream;
import jp.sfjp.armadillo.io.IOUtilities;
import jp.sfjp.armadillo.io.InspectionOutputStream;

public final class LzhFile
extends ArchiveFile {
    private File afile;
    private RandomAccessFile raf;
    private LzhHeader header;
    private LzhEntry ongoingEntry;
    private final LzhChecksum cksum;
    private final byte[] buffer;

    public LzhFile(File file) {
        this.afile = file;
        this.header = new LzhHeader();
        this.cksum = new LzhChecksum();
        this.buffer = new byte[8192];
    }

    public LzhFile(File file, boolean bl) throws IOException {
        this(file);
        this.open();
    }

    @Override
    public ArchiveEntry newEntry(String string) {
        LzhEntry lzhEntry = new LzhEntry(2);
        lzhEntry.setName(string);
        if (string.endsWith("/")) {
            lzhEntry.method = "-lhd-";
        }
        return lzhEntry;
    }

    @Override
    public void open() throws IOException {
        if (this.raf != null) {
            throw new IOException("the file has been already opened");
        }
        if (!this.afile.exists()) {
            this.afile.createNewFile();
        }
        this.raf = new RandomAccessFile(this.afile, "rw");
        this.opened = true;
    }

    @Override
    public void reset() throws IOException {
        this.ongoingEntry = null;
        this.currentPosition = 0L;
        this.raf.seek(0L);
    }

    @Override
    public ArchiveEntry nextEntry() throws IOException {
        this.ensureOpen();
        this.currentPosition = this.ongoingEntry == null ? 0L : (this.currentPosition += this.ongoingEntry.compressedSize);
        this.raf.seek(this.currentPosition);
        this.ongoingEntry = this.readCurrentEntry();
        this.currentPosition = this.raf.getFilePointer();
        return this.ongoingEntry;
    }

    @Override
    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        long l2;
        if (this.raf.length() == 0L) {
            l2 = 0L;
        } else {
            l2 = this.raf.length() - 1L;
            this.raf.seek(l2);
        }
        OutputStream outputStream = Channels.newOutputStream(this.raf.getChannel());
        LzhEntry lzhEntry = LzhArchiveCreator.toLzhEntry(archiveEntry);
        this.header.write(outputStream, lzhEntry);
        if (l > 0L) {
            long l3 = this.raf.getFilePointer();
            this.writeData(lzhEntry, inputStream, outputStream, l);
            this.raf.seek(l2);
            this.header.write(outputStream, lzhEntry);
            assert (this.raf.getFilePointer() == l3);
            this.raf.seek(l3 + lzhEntry.compressedSize);
        }
        this.raf.write(0);
        this.raf.seek(l2);
        this.currentPosition = l2;
    }

    private void writeData(LzhEntry lzhEntry, InputStream inputStream, OutputStream outputStream, long l) throws LzhException, IOException {
        long l2 = this.raf.getFilePointer();
        this.cksum.reset();
        OutputStream outputStream2 = LzhOutputStream.openStream(new AntiCloseOutputStream(outputStream), lzhEntry.getMethod());
        InspectionOutputStream inspectionOutputStream = new InspectionOutputStream(outputStream2, this.cksum);
        long l3 = IOUtilities.transfer(this.buffer, inputStream, inspectionOutputStream, l);
        assert (l3 == l);
        outputStream2.close();
        lzhEntry.compressedSize = this.raf.getFilePointer() - l2;
        lzhEntry.crc = this.cksum.getShortValue();
    }

    @Override
    public void updateEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        this.removeEntry(archiveEntry);
        this.addEntry(archiveEntry, inputStream, l);
    }

    @Override
    public void removeEntry(ArchiveEntry archiveEntry) throws IOException {
        if (!this.seek(archiveEntry)) {
            throw new LzhException("entry " + archiveEntry + " not found");
        }
        assert (this.ongoingEntry != null);
        int n = this.ongoingEntry.headerLength;
        long l = this.ongoingEntry.compressedSize;
        this.truncate(this.currentPosition - (long)n, (long)n + l);
    }

    LzhEntry readCurrentEntry() throws IOException {
        return this.header.read(Channels.newInputStream(this.raf.getChannel()));
    }

    void truncate(long l, long l2) throws IOException {
        long l3 = l;
        long l4 = l3 + l2;
        while (true) {
            this.raf.seek(l4);
            int n = this.raf.read(this.buffer);
            if (n <= 0) break;
            this.raf.seek(l3);
            this.raf.write(this.buffer, 0, n);
            l3 += (long)n;
            l4 += (long)n;
        }
        this.raf.setLength(this.raf.length() - l2);
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.raf.close();
        }
        finally {
            super.close();
            this.afile = null;
            this.header = null;
        }
    }

    private static final class AntiCloseOutputStream
    extends BufferedOutputStream {
        public AntiCloseOutputStream(OutputStream outputStream) {
            super(outputStream, 32768);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

