/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.lzh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.Arrays;
import jp.sfjp.armadillo.archive.lzh.LzhChecksum;
import jp.sfjp.armadillo.archive.lzh.LzhEntry;
import jp.sfjp.armadillo.archive.lzh.LzhException;

public final class LzhHeader {
    public static final byte HEADER_LEVEL_0 = 0;
    public static final byte HEADER_LEVEL_1 = 1;
    public static final byte HEADER_LEVEL_2 = 2;
    private static final int BUFFER_SIZE = 1024;
    private static final long MAX_DATA_SIZE = 0xFFFFFFFFL;
    private static final long UINT_MASK = 0xFFFFFFFFL;
    private static final int USHORT_MASK = 65535;
    private static final int UBYTE_MASK = 255;
    private static final int LEVEL_OFFSET = 20;
    private static final byte FILETYPE_FILE = 32;
    private static final byte PLATFORM_JAVA = 74;
    private static final byte PATH_DELIMITER = -1;
    private static final String ISO_8859_1 = "iso-8859-1";
    private static final String ERROR_PREFIX = "invalid header: ";
    private final ByteBuffer buffer = ByteBuffer.allocate(1024).order(ByteOrder.LITTLE_ENDIAN);

    public LzhEntry read(InputStream inputStream) throws IOException {
        LzhEntry lzhEntry;
        int n;
        this.buffer.clear();
        this.buffer.limit(21);
        Channels.newChannel(inputStream).read(this.buffer);
        int n2 = this.buffer.position();
        if (n2 == 0 || n2 == 1 && this.buffer.get(0) == 0 || n2 <= 21 && this.buffer.getShort(0) == 0) {
            return null;
        }
        if (n2 != 21) {
            return null;
        }
        byte by = this.buffer.get(20);
        this.buffer.rewind();
        switch (by) {
            case 0: 
            case 1: {
                n = (this.buffer.get() & 0xFF) + 2;
                break;
            }
            case 2: {
                n = this.buffer.getShort() & 0xFFFF;
                break;
            }
            default: {
                throw new LzhException("unsupported header level (=" + by + ")");
            }
        }
        if (n == 0) {
            return null;
        }
        assert (n >= 0 && n < 1024) : "header length = " + n;
        this.buffer.limit(n);
        this.buffer.position(21);
        Channels.newChannel(inputStream).read(this.buffer);
        if (this.buffer.position() != n) {
            throw new LzhException("invalid header: header length = " + n);
        }
        switch (by) {
            case 0: {
                lzhEntry = this.readLevel0();
                break;
            }
            case 1: {
                lzhEntry = this.readLevel1(inputStream);
                break;
            }
            case 2: {
                lzhEntry = this.readLevel2();
                break;
            }
            default: {
                throw new IllegalStateException("unexpected state");
            }
        }
        switch (by) {
            case 0: 
            case 1: {
                lzhEntry.headerLength += 2;
                break;
            }
        }
        assert (lzhEntry.headerLength == n);
        return lzhEntry;
    }

    private LzhEntry readLevel0() throws LzhException {
        this.buffer.position(0);
        byte by = this.buffer.get();
        byte by2 = this.buffer.get();
        byte[] byArray = this.getBytes(5);
        int n = this.buffer.getInt();
        int n2 = this.buffer.getInt();
        short s = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        byte by3 = this.buffer.get();
        byte by4 = this.buffer.get();
        byte by5 = this.buffer.get();
        byte[] byArray2 = this.getBytes(by5);
        short s3 = this.buffer.getShort();
        assert (by4 == 0);
        LzhEntry lzhEntry = new LzhEntry(0);
        lzhEntry.headerLength = by;
        lzhEntry.checksum = by2 & 0xFF;
        assert ((byArray[0] & 0x7F) == byArray[0]);
        assert ((byArray[1] & 0x7F) == byArray[1]);
        assert ((byArray[2] & 0x7F) == byArray[2]);
        assert ((byArray[3] & 0x7F) == byArray[3]);
        assert ((byArray[4] & 0x7F) == byArray[4]);
        lzhEntry.method = new String(byArray);
        lzhEntry.compressedSize = n;
        lzhEntry.size = n2;
        lzhEntry.setFtime(s2, s);
        lzhEntry.attribute = by3;
        lzhEntry.setName(byArray2);
        lzhEntry.crc = s3;
        lzhEntry.calculatedChecksum = this.calculateChecksum(2, this.buffer.limit());
        return lzhEntry;
    }

    private LzhEntry readLevel1(InputStream inputStream) throws IOException {
        this.buffer.position(0);
        LzhEntry lzhEntry = new LzhEntry(1);
        byte by = this.buffer.get();
        byte by2 = this.buffer.get();
        byte[] byArray = this.getBytes(5);
        int n = this.buffer.getInt();
        int n2 = this.buffer.getInt();
        short s = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        byte by3 = this.buffer.get();
        byte by4 = this.buffer.get();
        byte by5 = this.buffer.get();
        byte[] byArray2 = this.getBytes(by5);
        short s3 = this.buffer.getShort();
        byte by6 = this.buffer.get();
        assert (by4 == 1);
        assert (by3 == 32);
        lzhEntry.headerLength = by;
        lzhEntry.checksum = by2;
        assert ((byArray[0] & 0x7F) == byArray[0]);
        assert ((byArray[1] & 0x7F) == byArray[1]);
        assert ((byArray[2] & 0x7F) == byArray[2]);
        assert ((byArray[3] & 0x7F) == byArray[3]);
        assert ((byArray[4] & 0x7F) == byArray[4]);
        lzhEntry.method = new String(byArray);
        lzhEntry.size = n2;
        lzhEntry.setFtime(s2, s);
        lzhEntry.setName(byArray2);
        lzhEntry.crc = s3;
        lzhEntry.osIdentifier = by6;
        lzhEntry.calculatedChecksum = this.calculateChecksum(2, this.buffer.limit());
        int n3 = 0;
        lzhEntry.compressedSize = n - n3;
        return lzhEntry;
    }

    private LzhEntry readLevel2() throws IOException {
        this.buffer.position(0);
        short s = this.buffer.getShort();
        byte[] byArray = this.getBytes(5);
        int n = this.buffer.getInt();
        int n2 = this.buffer.getInt();
        int n3 = this.buffer.getInt();
        byte by = this.buffer.get();
        byte by2 = this.buffer.get();
        short s2 = this.buffer.getShort();
        byte by3 = this.buffer.get();
        short s3 = this.buffer.getShort();
        assert (by2 == 2);
        assert (by == 32);
        LzhEntry lzhEntry = new LzhEntry(2);
        lzhEntry.headerLength = s;
        assert ((byArray[0] & 0x7F) == byArray[0]);
        assert ((byArray[1] & 0x7F) == byArray[1]);
        assert ((byArray[2] & 0x7F) == byArray[2]);
        assert ((byArray[3] & 0x7F) == byArray[3]);
        assert ((byArray[4] & 0x7F) == byArray[4]);
        lzhEntry.method = new String(byArray);
        lzhEntry.compressedSize = n;
        lzhEntry.size = n2;
        lzhEntry.setTimeT(n3);
        lzhEntry.crc = s2;
        lzhEntry.osIdentifier = by3;
        int n4 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        short s4 = s3;
        while (s4 > 0) {
            byte by4 = this.buffer.get();
            int n5 = s4 - 3;
            this.buffer.mark();
            switch (by4) {
                case 0: {
                    this.buffer.getShort();
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(this.nextPath(n5));
                    break;
                }
                case 2: {
                    byteArrayOutputStream2.write(this.nextPath(n5));
                    break;
                }
                case 57: {
                    ++n4;
                    break;
                }
                case 65: {
                    this.buffer.getLong();
                    lzhEntry.setFileTime(this.buffer.getLong());
                    this.buffer.getLong();
                    break;
                }
                case 66: {
                    lzhEntry.compressedSize = this.buffer.getLong();
                    lzhEntry.size = this.buffer.getLong();
                    break;
                }
                case 84: {
                    lzhEntry.setTimeT(this.buffer.getInt());
                    break;
                }
                case 64: 
                case 80: 
                case 81: 
                case 82: 
                case 83: {
                    break;
                }
            }
            this.buffer.reset();
            this.buffer.position(this.buffer.position() + n5);
            s4 = this.buffer.getShort();
        }
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        if (byteArrayOutputStream2.size() > 0) {
            byteArrayOutputStream3.write(byteArrayOutputStream2.toByteArray());
            if (!byteArrayOutputStream3.toString().endsWith("/")) {
                byteArrayOutputStream3.write(47);
            }
        }
        if (byteArrayOutputStream.size() > 0) {
            byteArrayOutputStream3.write(byteArrayOutputStream.toByteArray());
        }
        assert (byteArrayOutputStream.size() == 0 == lzhEntry.isDirectory());
        lzhEntry.setName(byteArrayOutputStream3.toByteArray());
        assert (n4 == 0);
        return lzhEntry;
    }

    public void write(OutputStream outputStream, LzhEntry lzhEntry) throws IOException {
        if (!lzhEntry.method.matches("-l[hz][a-z0-9]-")) {
            throw new LzhException("invalid compression type: " + lzhEntry.method);
        }
        if (lzhEntry.compressedSize > Integer.MAX_VALUE) {
            throw new LzhException("too large compressed size: " + lzhEntry.compressedSize);
        }
        if (lzhEntry.size > Integer.MAX_VALUE) {
            throw new LzhException("too large size: " + lzhEntry.size);
        }
        if (lzhEntry.getNameAsBytes().length > Short.MAX_VALUE) {
            throw new LzhException("too long file name: length=" + lzhEntry.size);
        }
        if (lzhEntry.isDirectory()) {
            lzhEntry.method = "-lhd-";
        }
        this.buffer.clear();
        switch (lzhEntry.headerLevel) {
            case 0: {
                this.writeLevel0(lzhEntry);
                break;
            }
            case 1: {
                this.writeLevel1(lzhEntry);
                break;
            }
            case 2: {
                this.writeLevel2(lzhEntry);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid header: header-level=" + lzhEntry.headerLevel);
            }
        }
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
    }

    private void writeLevel0(LzhEntry lzhEntry) throws IOException {
        assert (lzhEntry.compressedSize >= 0L && lzhEntry.compressedSize <= 0xFFFFFFFFL);
        assert (lzhEntry.size >= 0L && lzhEntry.size <= 0xFFFFFFFFL);
        assert (lzhEntry.attribute == 32);
        byte[] byArray = lzhEntry.getNameAsBytes();
        assert (byArray.length <= 255);
        byte[] byArray2 = lzhEntry.method.getBytes(ISO_8859_1);
        assert (byArray2.length == 5);
        int n = (int)(lzhEntry.size & 0xFFFFFFFFL);
        int n2 = lzhEntry.getFTime();
        short s = (short)(n2 & 0xFFFF);
        short s2 = (short)(n2 << 16 & 0xFFFF);
        byte by = lzhEntry.attribute;
        byte by2 = 0;
        byte by3 = (byte)(byArray.length & 0xFF);
        short s3 = lzhEntry.crc;
        assert (this.buffer.position() == 0);
        this.buffer.putShort((short)0);
        this.buffer.put(byArray2);
        this.buffer.position(11);
        this.buffer.putInt(n);
        this.buffer.putShort(s);
        this.buffer.putShort(s2);
        this.buffer.put(by);
        this.buffer.put(by2);
        this.buffer.put(by3);
        this.buffer.put(byArray);
        this.buffer.putShort(s3);
        int n3 = this.buffer.position();
        if (n3 - 2 > 255) {
            throw new LzhException("invalid header length: " + (n3 - 2));
        }
        byte by4 = (byte)(n3 - 2 & 0xFF);
        byte by5 = (byte)(this.calculateChecksum(2, n3) & 0xFF);
        int n4 = lzhEntry.compressedSize > 0L ? LzhHeader.calculateSkipSize(lzhEntry, n, 0) : 0;
        this.buffer.put(0, by4);
        this.buffer.put(1, by5);
        this.buffer.putInt(7, n4);
    }

    private void writeLevel1(LzhEntry lzhEntry) throws IOException {
        assert (lzhEntry.compressedSize >= 0L && lzhEntry.compressedSize <= Integer.MAX_VALUE);
        assert (lzhEntry.size >= 0L && lzhEntry.size <= Integer.MAX_VALUE);
        byte[] byArray = lzhEntry.getNameAsBytes();
        assert (byArray.length <= 255);
        byte[] byArray2 = lzhEntry.method.getBytes(ISO_8859_1);
        assert (byArray2.length == 5);
        assert (lzhEntry.size >= 0L && lzhEntry.size <= 0xFFFFFFFFL);
        int n = (int)(lzhEntry.size & 0xFFFFFFFFL);
        int n2 = lzhEntry.getFTime();
        short s = (short)(n2 & 0xFFFF);
        short s2 = (short)(n2 << 16 & 0xFFFF);
        byte by = 32;
        byte by2 = 1;
        byte by3 = (byte)(byArray.length & 0xFF);
        byte by4 = 74;
        assert (this.buffer.position() == 0);
        this.buffer.putShort((short)0);
        this.buffer.put(byArray2);
        this.buffer.putInt(11);
        this.buffer.putInt(n);
        this.buffer.putShort(s);
        this.buffer.putShort(s2);
        this.buffer.put(by);
        this.buffer.put(by2);
        this.buffer.put(by3);
        this.buffer.put(byArray);
        this.buffer.putShort((short)0);
        this.buffer.put(by4);
        this.buffer.putShort((short)0);
        this.buffer.put((byte)0);
        int n3 = this.buffer.position();
        if (n3 - 2 > 255) {
            throw new LzhException("invalid header length: " + (n3 - 2));
        }
        byte by5 = (byte)(n3 - 2 & 0xFF);
        byte by6 = (byte)this.calculateChecksum(2, n3);
        int n4 = lzhEntry.compressedSize > 0L ? LzhHeader.calculateSkipSize(lzhEntry, n, 0) : 0;
        this.buffer.put(0, by5);
        this.buffer.put(1, by6);
        this.buffer.putInt(7, n4);
    }

    private void writeLevel2(LzhEntry lzhEntry) throws IOException {
        short s;
        short s2;
        assert (lzhEntry.compressedSize >= 0L && lzhEntry.compressedSize <= 0xFFFFFFFFL);
        assert (lzhEntry.size >= 0L && lzhEntry.size <= 0xFFFFFFFFL);
        byte[] byArray = lzhEntry.getNameAsBytes();
        assert (byArray.length <= 255);
        byte[] byArray2 = lzhEntry.method.getBytes(ISO_8859_1);
        assert (byArray2.length == 5);
        boolean bl = lzhEntry.isDirectory();
        assert (bl == lzhEntry.method.equals("-lhd-"));
        int n = bl ? 0 : (int)(lzhEntry.compressedSize & 0xFFFFFFFFL);
        int n2 = bl ? 0 : (int)(lzhEntry.size & 0xFFFFFFFFL);
        int n3 = lzhEntry.getTimeT();
        byte by = 32;
        byte by2 = 2;
        short s3 = lzhEntry.crc;
        byte by3 = 74;
        boolean bl2 = false;
        assert (this.buffer.position() == 0);
        this.buffer.putShort((short)0);
        this.buffer.put(byArray2);
        this.buffer.putInt(n);
        this.buffer.putInt(n2);
        this.buffer.putInt(n3);
        this.buffer.put(by);
        this.buffer.put(by2);
        this.buffer.putShort(s3);
        this.buffer.put(by3);
        short s4 = -1;
        for (s2 = 0; s2 < byArray.length; ++s2) {
            if (byArray[s2] != 47 && byArray[s2] != 92) continue;
            byArray[s2] = -1;
            s4 = s2;
        }
        s2 = s4 < 0 ? (short)0 : s4 + 1;
        int n4 = bl ? 0 : byArray.length - s2;
        this.buffer.putShort((short)(n4 + 3));
        this.buffer.put((byte)1);
        if (n4 > 0) {
            this.buffer.put(byArray, s2, n4);
        }
        if (s2 > 0) {
            byte[] byArray3 = Arrays.copyOf(byArray, byArray.length + 1);
            if (bl) {
                if (byArray[byArray.length - 1] != -1) {
                    s = byArray3.length;
                    byArray3[byArray.length - 1] = -1;
                } else {
                    s = byArray.length;
                }
            } else {
                s = s2;
            }
            this.buffer.putShort((short)(s + 3));
            this.buffer.put((byte)2);
            this.buffer.put(byArray3, 0, s);
        }
        this.buffer.putShort((short)27);
        this.buffer.put((byte)65);
        this.buffer.putLong(lzhEntry.getFileTime());
        this.buffer.putLong(lzhEntry.getFileTime());
        this.buffer.putLong(lzhEntry.getFileTime());
        this.buffer.putShort((short)6);
        this.buffer.put((byte)0);
        int n5 = this.buffer.position();
        this.buffer.putShort((short)0);
        this.buffer.put((byte)0);
        this.buffer.putShort((short)0);
        s = 0;
        s = (short)(s + this.buffer.position());
        if (s % 256 == 0) {
            this.buffer.put((byte)0);
            s = (short)(s + 1);
            assert (s >= 0);
        }
        short s5 = s;
        LzhChecksum lzhChecksum = new LzhChecksum();
        lzhChecksum.reset();
        lzhChecksum.update(this.buffer.array(), 0, s5);
        this.buffer.putShort(0, s5);
        this.buffer.putShort(n5, lzhChecksum.getShortValue());
    }

    private int calculateChecksum(int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 += this.buffer.get(i);
        }
        return n3;
    }

    private static int calculateSkipSize(LzhEntry lzhEntry, int n, int n2) throws LzhException {
        assert (lzhEntry.compressedSize >= 0L && lzhEntry.compressedSize <= Integer.MAX_VALUE);
        assert (lzhEntry.size >= 0L && lzhEntry.size <= Integer.MAX_VALUE);
        assert (n >= 0 && n2 >= 0);
        int n3 = 0;
        if (lzhEntry.getMethod().isCompressing()) {
            n3 = (int)((long)n3 + lzhEntry.compressedSize);
            n3 -= n;
        } else {
            n3 = (int)((long)n3 + lzhEntry.size);
        }
        assert ((n3 += n2) >= 0) : "skip size = " + n3;
        return n3;
    }

    private byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.buffer.get();
        }
        return byArray;
    }

    private byte[] nextPath(int n) {
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFFFFFFFF) != -1) continue;
            byArray[i] = 47;
        }
        return byArray;
    }
}

