/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.lzh;

import java.io.IOException;
import java.io.InputStream;
import jp.sfjp.armadillo.archive.ArchiveInputStream;
import jp.sfjp.armadillo.archive.lzh.LzhEntry;
import jp.sfjp.armadillo.archive.lzh.LzhHeader;
import jp.sfjp.armadillo.archive.lzh.LzhMethod;
import jp.sfjp.armadillo.compression.lzhuf.LzhHuffmanDecoder;
import jp.sfjp.armadillo.compression.lzhuf.LzssInputStream;

public final class LzhInputStream
extends ArchiveInputStream {
    private LzhHeader header = new LzhHeader();
    private LzhEntry nextEntry;

    public LzhInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public LzhEntry getNextEntry() throws IOException {
        LzhEntry lzhEntry;
        this.ensureOpen();
        if (this.remaining > 0L) {
            this.closeEntry();
        }
        if ((lzhEntry = this.header.read(this.in)) == null) {
            return null;
        }
        LzhMethod lzhMethod = new LzhMethod(lzhEntry.method);
        this.frontStream = lzhMethod.isCompressing() ? new LzssInputStream(new LzhHuffmanDecoder(this.in, lzhEntry.compressedSize), lzhMethod.getDictionarySize(), lzhMethod.getMatchSize(), lzhMethod.getThreshold()) : this.in;
        this.remaining = lzhEntry.size;
        this.nextEntry = lzhEntry;
        return lzhEntry;
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        if (this.nextEntry != null && this.remaining == this.nextEntry.size) {
            this.frontStream = this.in;
            this.remaining = this.nextEntry.compressedSize;
        }
        while (this.remaining > 0L) {
            this.skip(this.remaining);
        }
        assert (this.remaining == 0L) : "rest=" + this.remaining;
        this.nextEntry = null;
        this.frontStream = this.in;
    }

    @Override
    public void close() throws IOException {
        this.header = null;
        super.close();
    }
}

