/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.lzh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jp.sfjp.armadillo.archive.ArchiveOutputStream;
import jp.sfjp.armadillo.archive.lzh.LzhChecksum;
import jp.sfjp.armadillo.archive.lzh.LzhEntry;
import jp.sfjp.armadillo.archive.lzh.LzhHeader;
import jp.sfjp.armadillo.archive.lzh.LzhMethod;
import jp.sfjp.armadillo.compression.lzhuf.LzhHuffmanEncoder;
import jp.sfjp.armadillo.compression.lzhuf.LzssOutputStream;
import jp.sfjp.armadillo.io.InspectionOutputStream;

public final class LzhOutputStream
extends ArchiveOutputStream {
    private LzhHeader header = new LzhHeader();
    private LzhEntry ongoingEntry;
    private InspectionOutputStream ios;
    private LzhChecksum crc = new LzhChecksum();
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();

    public LzhOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void putNextEntry(LzhEntry lzhEntry) throws IOException {
        if (this.ongoingEntry != null) {
            this.closeEntry();
        }
        this.ongoingEntry = lzhEntry;
        LzhMethod lzhMethod = lzhEntry.getMethod();
        this.crc.reset();
        this.bos.reset();
        this.ios = new InspectionOutputStream(LzhOutputStream.openStream(this.bos, lzhMethod), this.crc);
        this.frontStream = this.ios;
    }

    static OutputStream openStream(OutputStream outputStream, LzhMethod lzhMethod) {
        if (lzhMethod.isCompressing()) {
            return new LzssOutputStream(new LzhHuffmanEncoder(outputStream, lzhMethod.getThreshold()), lzhMethod.getDictionarySize(), lzhMethod.getMatchSize(), lzhMethod.getThreshold());
        }
        return outputStream;
    }

    public void closeEntry() throws IOException {
        this.frontStream.flush();
        if (this.frontStream != this.out) {
            this.frontStream.close();
        }
        this.frontStream = this.out;
        if (this.ios != null) {
            this.ongoingEntry.compressedSize = this.bos.size();
            this.ongoingEntry.crc = this.getCrc();
        }
        this.writeHeader(this.ongoingEntry);
        if (this.ios != null) {
            this.bos.writeTo(this.out);
        }
        this.ongoingEntry = null;
        this.ios = null;
        this.crc.reset();
        this.bos.reset();
    }

    public void writeHeader(LzhEntry lzhEntry) throws IOException {
        this.header.write(this.out, lzhEntry);
    }

    public void writeHeader(LzhEntry lzhEntry, OutputStream outputStream) throws IOException {
        this.header.write(outputStream, lzhEntry);
    }

    public short getCrc() {
        return this.crc.getShortValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.flush();
            super.write(0);
            super.flush();
        }
        finally {
            this.header = null;
            this.ongoingEntry = null;
            this.ios = null;
            this.crc = null;
            this.bos = null;
            super.close();
        }
    }
}

