/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import jp.sfjp.armadillo.archive.ArchiveType;
import jp.sfjp.armadillo.archive.DumpArchiveHeader;
import jp.sfjp.armadillo.time.TimeT;

public final class DumpTarHeader
extends DumpArchiveHeader {
    private static final int BLOCK_SIZE = 512;
    private static final String MAGIC_USTAR = "ustar";
    private static final TimeT TIME_T = new TimeT();
    private static final String fmt1 = "  * %s = %s%n";
    private static final String fmt2 = "  %1$-16s = [0x%2$08X] [0o%2$012o] ( %2$d )%n";
    private static final String fmt3 = "  %-16s = \"%s\"%n";
    private final ByteBuffer buffer = ByteBuffer.allocate(512);

    @Override
    public void dump(InputStream inputStream, PrintWriter printWriter) throws IOException {
        int n = 0;
        while (true) {
            this.printOffset(printWriter, n);
            int n2 = DumpTarHeader.draw(inputStream, this.buffer);
            if (n2 == 0) break;
            n += n2;
            if (n2 != 512) {
                DumpTarHeader.warn(printWriter, "bad header: size=%d", n2);
            }
            if (this.isEmptyBlock()) {
                printWriter.println("  ( EMPTY BLOCK )");
                continue;
            }
            try {
                if (this.isUstar()) {
                    n += this.readUstar(inputStream, printWriter);
                    continue;
                }
                n += this.readTar(inputStream, printWriter);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        this.printEnd(printWriter, "TAR", n);
    }

    private boolean isUstar() {
        String string = new String(this.buffer.array(), 257, 5);
        return string.equals(MAGIC_USTAR);
    }

    private static int draw(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        byteBuffer.clear();
        byteBuffer.limit(512);
        Channels.newChannel(inputStream).read(byteBuffer);
        int n = byteBuffer.position();
        byteBuffer.rewind();
        return n;
    }

    private int readTar(InputStream inputStream, PrintWriter printWriter) throws IOException {
        int n = 0;
        String string = this.clip(100);
        int n2 = this.clipAsInt(8);
        int n3 = this.clipAsInt(8);
        int n4 = this.clipAsInt(8);
        long l = this.clipAsLong(12);
        long l2 = this.clipAsLong(12);
        int n5 = this.clipAsInt(8);
        int n6 = this.clipAsInt(1);
        this.clip(100);
        this.printHeaderName(printWriter, "TAR (old) format");
        printWriter.printf(fmt1, "name", string);
        DumpTarHeader.p(printWriter, "mode", n2, 8);
        DumpTarHeader.p(printWriter, "uid", n3, 8);
        DumpTarHeader.p(printWriter, "gid", n4, 8);
        DumpTarHeader.p(printWriter, "size", l, 12);
        DumpTarHeader.p(printWriter, "mtime", l2, 12);
        DumpTarHeader.p(printWriter, "chksum", n5, 8);
        DumpTarHeader.p(printWriter, "link", n6, 1);
        if (l > 0L) {
            n = (int)((long)n + this.skipBlock(inputStream, l));
        }
        return n;
    }

    private int readUstar(InputStream inputStream, PrintWriter printWriter) throws IOException {
        int n = 0;
        String string = this.clip(100);
        int n2 = this.clipAsInt(8);
        int n3 = this.clipAsInt(8);
        int n4 = this.clipAsInt(8);
        long l = this.clipAsLong(12);
        long l2 = this.clipAsLong(12);
        int n5 = this.clipAsInt(8);
        char c = this.clipAsChar();
        String string2 = this.clip(100);
        String string3 = this.clip(6);
        int n6 = this.clipAsInt(2);
        String string4 = this.clip(32);
        String string5 = this.clip(32);
        int n7 = this.clipAsInt(8);
        int n8 = this.clipAsInt(8);
        String string6 = this.clip(155);
        this.printHeaderName(printWriter, "USTAR format");
        printWriter.printf(fmt1, "name", string);
        printWriter.printf(fmt1, "mtime as date", DumpTarHeader.toDate(l2));
        DumpTarHeader.p(printWriter, "mode", n2, 8);
        DumpTarHeader.p(printWriter, "uid", n3, 8);
        DumpTarHeader.p(printWriter, "gid", n4, 8);
        DumpTarHeader.p(printWriter, "size", l, 12);
        DumpTarHeader.p(printWriter, "mtime", l2, 12);
        DumpTarHeader.p(printWriter, "chksum", n5, 8);
        printWriter.printf(fmt3, "typeflag", Character.valueOf(c));
        printWriter.printf(fmt3, "linkname", string2);
        printWriter.printf(fmt3, "magic", string3);
        printWriter.printf(fmt2, "version", n6);
        printWriter.printf(fmt3, "uname", string4);
        printWriter.printf(fmt3, "gname", string5);
        printWriter.printf(fmt2, "devmajor", n7);
        printWriter.printf(fmt2, "devminor", n8);
        printWriter.printf(fmt3, "prefix", string6);
        if (c == 'L') {
            n += DumpTarHeader.draw(inputStream, this.buffer);
            String string7 = this.clip(512);
            printWriter.printf(fmt1, "LongLink", string7);
        } else if (l > 0L) {
            n = (int)((long)n + this.skipBlock(inputStream, l));
        }
        return n;
    }

    private long skipBlock(InputStream inputStream, long l) throws IOException {
        long l2 = 0L;
        long l3 = l;
        while (l3 > 0L) {
            long l4 = inputStream.skip(512L);
            if (l4 != 512L && (l3 -= l4) > 0L) {
                throw new IllegalStateException("bad skip size: " + l4);
            }
            l2 += l4;
        }
        return l2;
    }

    private String clip(int n) {
        int n2 = this.buffer.position();
        int n3 = 0;
        for (int i = 0; i < n && this.buffer.get() != 0; ++i) {
            ++n3;
        }
        this.buffer.rewind();
        this.buffer.position(n2);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.buffer.get() & 0xFF;
            if (n4 < 32 || n4 > 127) {
                stringBuilder.append(String.format("\\%o", n4));
                continue;
            }
            stringBuilder.append((char)n4);
        }
        this.buffer.position(n2 + n);
        return stringBuilder.toString();
    }

    private char clipAsChar() {
        String string = this.clip(1);
        assert (string.length() == 1 && string.matches("^[A-Za-z0-9]$"));
        return string.charAt(0);
    }

    private int clipAsInt(int n) {
        String string = this.clipAsNumberString(n);
        return string.isEmpty() ? 0 : Integer.parseInt(string, 8);
    }

    private long clipAsLong(int n) {
        String string = this.clipAsNumberString(n);
        return string.isEmpty() ? 0L : Long.parseLong(string, 8);
    }

    private String clipAsNumberString(int n) {
        byte by;
        int n2;
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        for (n2 = 0; n2 < n && (by = byArray[n2]) != 0; ++n2) {
            assert (by == 32 || by >= 48 && by <= 57);
        }
        return new String(byArray, 0, n2).trim();
    }

    private boolean isEmptyBlock() {
        byte[] byArray = this.buffer.array();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    static long getSkipSize(long l) {
        if (l == 0L || l == 512L || l % 512L == 0L) {
            return 0L;
        }
        return 512L - (l > 512L ? l % 512L : l);
    }

    static InputStream getInputStream(File file) throws IOException {
        ArchiveType archiveType = ArchiveType.of(file.getName());
        switch (archiveType) {
            case TAR: {
                return new FileInputStream(file);
            }
            case TARGZ: {
                return new GZIPInputStream(new FileInputStream(file));
            }
        }
        throw new UnsupportedOperationException("not TAR ? : " + (Object)((Object)archiveType));
    }

    static Date toDate(long l) {
        return new Date(TIME_T.toMilliseconds(l));
    }

    static <T> void p(PrintWriter printWriter, String string, T t, int n) {
        int n2;
        int n3;
        switch (n) {
            case 1: {
                n3 = 2;
                n2 = 2;
                break;
            }
            case 8: {
                n3 = 6;
                n2 = 8;
                break;
            }
            case 12: {
                n3 = 6;
                n2 = 8;
                break;
            }
            default: {
                n3 = 8;
                n2 = n;
            }
        }
        String string2 = "  %1$-16s = [0x%2$0" + n3 + "X] [0o%2$0" + n2 + "o] ( %2$d )%n";
        printWriter.printf(string2, string, t);
    }
}

