/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.tar;

import java.io.File;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.time.TimeT;

public final class TarEntry
extends ArchiveEntry {
    public static final int DEFAULT_MODE_DIR = 493;
    public static final int DEFAULT_MODE_FILE = 438;
    private static final TimeT TIME_T = new TimeT();
    private int mode = 0;
    int uid = -1;
    int gid = -1;
    long size = 0L;
    long mtime = 0L;
    int chksum = 0;
    char typeflag = '\u0000';
    String linkname = "";
    String magic = "ustar";
    String version = "";
    String uname = "unknown";
    String gname = "unknown";
    String devmajor = "";
    String devminor = "";
    String prefix = "";

    TarEntry() {
        super(false);
    }

    public TarEntry(String string) {
        this();
        this.setName(string);
        this.mode = this.isDirectory() ? 493 : 438;
    }

    public TarEntry(String string, File file) {
        this(string);
        this.setFileInfo(file);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long l) {
        if (!this.isDirectory()) {
            this.size = l;
        }
    }

    @Override
    public long getCompressedSize() {
        return -1L;
    }

    @Override
    public void setCompressedSize(long l) {
    }

    @Override
    public long getLastModified() {
        return TIME_T.toMilliseconds(this.mtime);
    }

    @Override
    public void setLastModified(long l) {
        this.mtime = TIME_T.int64From(l);
    }

    @Override
    public String getMethodName() {
        if (!this.magic.trim().isEmpty()) {
            return this.magic.trim();
        }
        return "TAR";
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int n) {
        this.uid = n;
    }

    public int getGid() {
        return this.gid;
    }

    public void setGid(int n) {
        this.gid = n;
    }

    public long getMtime() {
        return this.mtime;
    }

    public void setMtime(long l) {
        this.mtime = l;
    }

    public int getChksum() {
        return this.chksum;
    }

    public void setChksum(int n) {
        this.chksum = n;
    }

    public char getTypeflag() {
        return this.typeflag;
    }

    public void setTypeflag(char c) {
        this.typeflag = c;
    }

    public String getLinkname() {
        return this.linkname;
    }

    public void setLinkname(String string) {
        this.linkname = string;
    }

    public String getMagic() {
        return this.magic;
    }

    public void setMagic(String string) {
        this.magic = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getUname() {
        return this.uname;
    }

    public void setUname(String string) {
        this.uname = string;
    }

    public String getGname() {
        return this.gname;
    }

    public void setGname(String string) {
        this.gname = string;
    }

    public String getDevmajor() {
        return this.devmajor;
    }

    public void setDevmajor(String string) {
        this.devmajor = string;
    }

    public String getDevminor() {
        return this.devminor;
    }

    public void setDevminor(String string) {
        this.devminor = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }
}

