/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.tar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.ArchiveFile;
import jp.sfjp.armadillo.archive.tar.TarArchiveCreator;
import jp.sfjp.armadillo.archive.tar.TarEntry;
import jp.sfjp.armadillo.archive.tar.TarException;
import jp.sfjp.armadillo.archive.tar.TarHeader;

public final class TarFile
extends ArchiveFile {
    private File afile;
    private RandomAccessFile raf;
    private TarHeader header;
    private TarEntry ongoingEntry;
    private final byte[] buffer;

    public TarFile(File file) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("not a file: " + file.getPath());
        }
        this.afile = file;
        this.header = new TarHeader();
        this.buffer = new byte[512];
    }

    @Override
    public void open() throws IOException {
        if (this.raf != null) {
            throw new IOException("the file has been already opened");
        }
        if (!this.afile.exists()) {
            this.afile.createNewFile();
        }
        this.raf = new RandomAccessFile(this.afile, "rw");
        this.opened = true;
    }

    @Override
    public void reset() throws IOException {
        this.ongoingEntry = null;
        this.currentPosition = 0L;
        this.raf.seek(0L);
    }

    @Override
    public ArchiveEntry nextEntry() throws IOException {
        this.ensureOpen();
        if (this.ongoingEntry == null) {
            this.currentPosition = 0L;
        } else {
            long l = this.ongoingEntry.size;
            long l2 = 512L + l + TarHeader.getSkipSize(l);
            assert (l2 % 512L == 0L);
            this.currentPosition += l2;
        }
        this.raf.seek(this.currentPosition);
        this.ongoingEntry = this.readCurrentEntry();
        this.raf.seek(this.currentPosition + 512L);
        return this.ongoingEntry;
    }

    @Override
    public boolean seek(ArchiveEntry archiveEntry) throws IOException {
        ArchiveEntry archiveEntry2;
        this.ensureOpen();
        this.reset();
        while ((archiveEntry2 = this.nextEntry()) != null) {
            if (!archiveEntry2.getName().equals(archiveEntry.getName())) continue;
            return true;
        }
        this.reset();
        return false;
    }

    public void seekEndOfLastEntry() throws IOException {
        this.ensureOpen();
        this.reset();
        while (this.nextEntry() != null) {
        }
    }

    @Override
    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        long l2 = TarFile.calculateBlockCount(l);
        FileChannel fileChannel = this.raf.getChannel();
        this.seekEndOfLastEntry();
        this.raf.seek(this.currentPosition);
        this.insertEmptyBlock(this.raf.getFilePointer(), l2 + 1L);
        TarEntry tarEntry = TarFile.toTarEntry(archiveEntry);
        this.header.write(Channels.newOutputStream(fileChannel), tarEntry);
        if (l2 > 0L) {
            long l3 = this.currentPosition + 512L;
            long l4 = fileChannel.transferFrom(Channels.newChannel(inputStream), l3, l);
            assert (l4 == l);
        }
        this.raf.seek(this.currentPosition);
        this.ongoingEntry = tarEntry;
    }

    @Override
    public void updateEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        if (!this.seek(archiveEntry)) {
            throw new TarException("entry " + archiveEntry + " not found");
        }
        this.raf.seek(this.currentPosition);
        this.header.write(Channels.newOutputStream(this.raf.getChannel()), TarFile.toTarEntry(archiveEntry));
        if (l > 0L) {
            long l2 = TarFile.calculateBlockCount(this.ongoingEntry.size);
            long l3 = TarFile.calculateBlockCount(l);
            assert (l3 > 0L);
            long l4 = this.currentPosition + 512L;
            if (l3 < l2) {
                this.truncateBlock(l4, l2 - l3);
            }
            if (l3 <= l2) {
                this.raf.seek(l4 + (l3 - 1L) * 512L);
                this.raf.write(this.buffer);
            } else {
                this.insertEmptyBlock(l4, l3 - l2);
            }
            this.raf.getChannel().transferFrom(Channels.newChannel(inputStream), l4, l);
        }
        this.raf.seek(this.currentPosition);
        this.ongoingEntry = TarArchiveCreator.toTarEntry(archiveEntry);
    }

    @Override
    public void removeEntry(ArchiveEntry archiveEntry) throws IOException {
        if (!this.seek(archiveEntry)) {
            throw new TarException("entry " + archiveEntry + " not found");
        }
        this.raf.seek(this.currentPosition);
        assert (this.ongoingEntry != null);
        long l = this.ongoingEntry.size;
        if (l == 0L) {
            this.truncate(this.currentPosition, 512L);
        } else {
            long l2 = 512L + l + TarHeader.getSkipSize(l);
            assert (l2 >= 0L && l2 <= Integer.MAX_VALUE);
            assert (l2 % 512L == 0L);
            this.truncate(this.currentPosition, l2);
        }
    }

    static TarEntry toTarEntry(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof TarEntry) {
            return (TarEntry)archiveEntry;
        }
        TarEntry tarEntry = new TarEntry(archiveEntry.getName());
        archiveEntry.copyTo(tarEntry);
        return tarEntry;
    }

    @Override
    public ArchiveEntry newEntry(String string) {
        return new TarEntry(string);
    }

    public void insertEmptyBlock(long l, long l2) throws IOException {
        long l3 = l2 * 512L;
        this.raf.seek(this.raf.length() + l3 - 1L);
        this.raf.write(0);
        long l4 = this.raf.getFilePointer();
        long l5 = l4 - 512L;
        long l6 = l5 - l3;
        assert (l6 > 0L && l5 > 0L);
        byte[] byArray = this.buffer;
        int n = 0;
        while ((long)n < l2 && l6 >= l) {
            this.raf.seek(l6);
            this.raf.readFully(byArray);
            this.raf.seek(l5);
            this.raf.write(byArray);
            l6 -= 512L;
            l5 -= 512L;
            ++n;
        }
        this.currentPosition = l;
        this.raf.seek(this.currentPosition);
    }

    void truncateBlock(long l, long l2) throws IOException {
        this.truncate(l, l2 * 512L);
    }

    void truncate(long l, long l2) throws IOException {
        long l3 = l;
        long l4 = l3 + l2;
        long l5 = this.raf.length() - l4;
        assert (l5 >= 512L && l5 % 512L == 0L);
        byte[] byArray = new byte[512];
        long l6 = TarFile.calculateBlockCount(l5);
        int n = 0;
        while ((long)n < l6) {
            this.raf.seek(l4);
            this.raf.readFully(byArray);
            this.raf.seek(l3);
            this.raf.write(byArray);
            l3 += 512L;
            l4 += 512L;
            ++n;
        }
        this.raf.setLength(this.raf.length() - l2);
        this.reset();
    }

    TarEntry readCurrentEntry() throws IOException {
        return this.header.read(Channels.newInputStream(this.raf.getChannel()));
    }

    static long calculateBlockCount(long l) {
        long l2;
        if (l == 0L) {
            return 0L;
        }
        long l3 = l - (l2 = l / 512L) * 512L;
        return l2 + (long)(l3 > 0L ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.raf.close();
        }
        finally {
            super.close();
            this.afile = null;
            this.header = null;
        }
    }
}

