/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.tar;

import java.io.IOException;
import java.io.InputStream;
import jp.sfjp.armadillo.archive.ArchiveInputStream;
import jp.sfjp.armadillo.archive.tar.TarEntry;
import jp.sfjp.armadillo.archive.tar.TarHeader;

public final class TarInputStream
extends ArchiveInputStream {
    private TarHeader header = new TarHeader();
    private long skipSize = 0L;

    public TarInputStream(InputStream inputStream) {
        super(inputStream);
        this.frontStream = inputStream;
    }

    public TarEntry getNextEntry() throws IOException {
        long l;
        this.ensureOpen();
        if (this.remaining + this.skipSize > 0L) {
            this.remaining += this.skipSize;
            while (this.remaining > 0L) {
                long l2 = this.in.skip(this.remaining);
                this.remaining -= l2;
            }
        }
        this.remaining = 0L;
        this.skipSize = 0L;
        TarEntry tarEntry = this.header.read(this.in);
        if (tarEntry == null) {
            return null;
        }
        this.remaining = l = tarEntry.getSize();
        this.skipSize = TarHeader.getSkipSize(l);
        return tarEntry;
    }

    @Override
    public void close() throws IOException {
        this.header = null;
        super.close();
    }
}

