/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.Date;
import java.util.zip.ZipException;
import jp.sfjp.armadillo.archive.DumpArchiveHeader;
import jp.sfjp.armadillo.archive.zip.ZipEntry;
import jp.sfjp.armadillo.io.RewindableInputStream;

public final class DumpZipHeader
extends DumpArchiveHeader {
    private static final String fmt1 = "  * %s = %s%n";
    private static final String fmt2 = "  %1$-16s = [0x%2$08X] ( %2$d )%n";
    private static final int siglen = 4;
    private static final int siglen_m1 = 3;
    static final int SIGN_LOC = 67324752;
    static final int SIGN_CEN = 33639248;
    static final int SIGN_END = 101010256;
    static final int SIGN_EXT = 134695760;
    static final int LENGTH_LOC = 30;
    static final int LENGTH_CEN = 46;
    static final int LENGTH_END = 22;
    static final int LENGTH_EXT = 16;
    private final ByteBuffer buffer = ByteBuffer.allocate(46).order(ByteOrder.LITTLE_ENDIAN);

    @Override
    public void dump(InputStream inputStream, PrintWriter printWriter) throws IOException {
        byte[] byArray = new byte[65536];
        int n = 0;
        RewindableInputStream rewindableInputStream = new RewindableInputStream(inputStream, 65536);
        while (true) {
            int n2;
            Arrays.fill(byArray, (byte)0);
            int n3 = rewindableInputStream.read(byArray);
            if (n3 <= 0) break;
            int n4 = DumpZipHeader.findPK(byArray);
            if (n4 < 0) {
                if (n3 < 4) break;
                rewindableInputStream.rewind(3);
                n += n3 - 3;
                continue;
            }
            if (n4 == 0) {
                rewindableInputStream.rewind(n3);
            } else if (n4 < 65532) {
                rewindableInputStream.rewind(n3 - n4);
            }
            this.printOffset(printWriter, n += n4);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n4, 4).order(ByteOrder.LITTLE_ENDIAN);
            int n5 = byteBuffer.getInt();
            switch (n5) {
                case 67324752: {
                    n2 = this.readLOC(rewindableInputStream, printWriter);
                    break;
                }
                case 33639248: {
                    n2 = this.readCEN(rewindableInputStream, printWriter);
                    break;
                }
                case 101010256: {
                    n2 = this.readEND(rewindableInputStream, printWriter);
                    break;
                }
                case 134695760: {
                    n2 = this.readEXT(rewindableInputStream, printWriter);
                    break;
                }
                default: {
                    DumpZipHeader.warn(printWriter, "[%08X] is not a signature", n5);
                    n2 = 0;
                }
            }
            assert (n2 >= 0);
            if (n2 > 0) {
                n += n2;
                continue;
            }
            rewindableInputStream.read();
            ++n;
        }
        this.printEnd(printWriter, "ZIP", n);
    }

    static int findPK(byte[] byArray) {
        int n = byArray.length - 3;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != 80 || byArray[i + 1] != 75) continue;
            return i;
        }
        return -1;
    }

    int readLOC(InputStream inputStream, PrintWriter printWriter) throws IOException {
        String string;
        int n = 0;
        this.buffer.clear();
        this.buffer.limit(30);
        Channels.newChannel(inputStream).read(this.buffer);
        n += this.buffer.position();
        this.buffer.rewind();
        int n2 = this.buffer.getInt();
        short s = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        short s3 = this.buffer.getShort();
        short s4 = this.buffer.getShort();
        short s5 = this.buffer.getShort();
        int n3 = this.buffer.getInt();
        int n4 = this.buffer.getInt();
        int n5 = this.buffer.getInt();
        short s6 = this.buffer.getShort();
        short s7 = this.buffer.getShort();
        assert (s6 >= 0);
        if (s6 == 0) {
            string = "";
        } else {
            byte[] byArray = new byte[s6];
            int n6 = inputStream.read(byArray);
            string = new String(byArray);
            if (n6 != s6) {
                DumpZipHeader.warn(printWriter, "namelen=%d, read=%d, name=%s", s6, n6, string);
            }
            n += n6;
        }
        if (s7 > 0) {
            long l = inputStream.skip(s7);
            if (l != (long)s7) {
                throw new ZipException("invalid LOC header (extra length)");
            }
            n = (int)((long)n + l);
        }
        this.printHeaderName(printWriter, "LOC header");
        printWriter.printf(fmt1, "name", string);
        printWriter.printf(fmt1, "mtime as date", DumpZipHeader.toDate(s5, s4));
        printWriter.printf(fmt2, "signature", n2);
        printWriter.printf(fmt2, "version", s);
        printWriter.printf(fmt2, "flags", s2);
        printWriter.printf(fmt2, "method", s3);
        printWriter.printf(fmt2, "mtime", s4);
        printWriter.printf(fmt2, "mdate", s5);
        printWriter.printf(fmt2, "crc", n3);
        printWriter.printf(fmt2, "compsize", n4);
        printWriter.printf(fmt2, "uncompsize", n5);
        printWriter.printf(fmt2, "namelen", s6);
        printWriter.printf(fmt2, "extlen", s7);
        return n;
    }

    int readCEN(InputStream inputStream, PrintWriter printWriter) throws IOException {
        String string;
        int n = 0;
        this.buffer.clear();
        this.buffer.limit(46);
        Channels.newChannel(inputStream).read(this.buffer);
        n += this.buffer.position();
        if (this.buffer.position() == 0) {
            return n;
        }
        this.buffer.rewind();
        int n2 = this.buffer.getInt();
        short s = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        short s3 = this.buffer.getShort();
        short s4 = this.buffer.getShort();
        short s5 = this.buffer.getShort();
        short s6 = this.buffer.getShort();
        int n3 = this.buffer.getInt();
        int n4 = this.buffer.getInt();
        int n5 = this.buffer.getInt();
        short s7 = this.buffer.getShort();
        short s8 = this.buffer.getShort();
        short s9 = this.buffer.getShort();
        short s10 = this.buffer.getShort();
        short s11 = this.buffer.getShort();
        int n6 = this.buffer.getInt();
        int n7 = this.buffer.getInt();
        if (s7 > 0) {
            short s12 = s7;
            byte[] byArray = new byte[s12];
            int n8 = inputStream.read(byArray);
            string = new String(byArray);
            if (n8 != s7) {
                DumpZipHeader.warn(printWriter, "namelen=%d, read=%d, name=%s", s7, n8, string);
            }
        } else {
            string = "";
        }
        if (s8 > 0) {
            long l = inputStream.skip(s8);
            if (l != (long)s8) {
                throw new ZipException("invalid CEN header (extra length)");
            }
            n = (int)((long)n + l);
        }
        if (s9 > 0) {
            System.out.println();
        }
        this.printHeaderName(printWriter, "CEN header");
        printWriter.printf(fmt1, "name", string);
        printWriter.printf(fmt1, "mtime as date", DumpZipHeader.toDate(s6, s5));
        printWriter.printf(fmt2, "signature", n2);
        printWriter.printf(fmt2, "madever", s);
        printWriter.printf(fmt2, "needver", s2);
        printWriter.printf(fmt2, "flags", s3);
        printWriter.printf(fmt2, "method", s4);
        printWriter.printf(fmt2, "mtime", s5);
        printWriter.printf(fmt2, "mdate", s6);
        printWriter.printf(fmt2, "crc", n3);
        printWriter.printf(fmt2, "compsize", n4);
        printWriter.printf(fmt2, "uncompsize", n5);
        printWriter.printf(fmt2, "namelen", s7);
        printWriter.printf(fmt2, "extlen", s8);
        printWriter.printf(fmt2, "fcmlen", s9);
        printWriter.printf(fmt2, "dnum", s10);
        printWriter.printf(fmt2, "infattr", s11);
        printWriter.printf(fmt2, "exfattr", n6);
        printWriter.printf(fmt2, "reloff", n7);
        return n;
    }

    int readEND(InputStream inputStream, PrintWriter printWriter) throws IOException {
        String string;
        int n = 0;
        this.buffer.clear();
        this.buffer.limit(22);
        Channels.newChannel(inputStream).read(this.buffer);
        n += this.buffer.position();
        this.buffer.rewind();
        int n2 = this.buffer.getInt();
        short s = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        short s3 = this.buffer.getShort();
        short s4 = this.buffer.getShort();
        int n3 = this.buffer.getInt();
        int n4 = this.buffer.getInt();
        short s5 = this.buffer.getShort();
        if (s5 > 0) {
            byte[] byArray = new byte[s5];
            int n5 = inputStream.read(byArray);
            if (n5 != s5) {
                throw new ZipException("invalid END header (comment length)");
            }
            n += n5;
            string = new String(byArray);
        } else {
            string = "";
        }
        this.printHeaderName(printWriter, "END header");
        printWriter.printf(fmt2, "signature", n2);
        printWriter.printf(fmt2, "ndisk", s);
        printWriter.printf(fmt2, "ndiskCEN", s2);
        printWriter.printf(fmt2, "countDiskCENs", s3);
        printWriter.printf(fmt2, "countCENs", s4);
        printWriter.printf(fmt2, "sizeCENs", n3);
        printWriter.printf(fmt2, "offsetCENs", n4);
        printWriter.printf(fmt2, "commentlen", s5);
        printWriter.printf(fmt1, "comment", string);
        return n;
    }

    int readEXT(InputStream inputStream, PrintWriter printWriter) throws IOException {
        int n = 0;
        this.buffer.clear();
        this.buffer.limit(16);
        Channels.newChannel(inputStream).read(this.buffer);
        n += this.buffer.position();
        this.buffer.rewind();
        int n2 = this.buffer.getInt();
        int n3 = this.buffer.getInt();
        int n4 = this.buffer.getInt();
        int n5 = this.buffer.getInt();
        this.printHeaderName(printWriter, "EXT header");
        printWriter.printf(fmt2, "signature", n2);
        printWriter.printf(fmt2, "crc", n3);
        printWriter.printf(fmt2, "compsize", n4);
        printWriter.printf(fmt2, "uncompsize", n5);
        return n;
    }

    static Date toDate(short s, short s2) {
        ZipEntry zipEntry = new ZipEntry();
        zipEntry.mdate = s;
        zipEntry.mtime = s2;
        return new Date(zipEntry.getLastModified());
    }
}

