/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.io;

public final class ByteQueue {
    private static final int DEFAULT_CAPACITY = 8192;
    private int p = 0;
    private int q = 0;
    private byte[] buffer;

    public ByteQueue() {
        this(8192);
    }

    public ByteQueue(int n) {
        this.buffer = new byte[n];
    }

    public int size() {
        return this.q;
    }

    public void enqueue(byte[] byArray) {
        this.enqueue(byArray, 0, byArray.length);
    }

    public void enqueue(byte[] byArray, int n, int n2) {
        int n3 = this.buffer.length - this.q;
        if (n2 > n3 && !this.ensureBuffer(n2)) {
            throw new IllegalStateException("failed to ensure buffer");
        }
        System.arraycopy(byArray, n, this.buffer, this.p + this.q, n2);
        this.q += n2;
    }

    public byte[] dequeue(int n) {
        byte[] byArray = new byte[n];
        this.dequeue(byArray, 0, n);
        return byArray;
    }

    public void dequeue(byte[] byArray) {
        this.dequeue(byArray, 0, byArray.length);
    }

    public void dequeue(byte[] byArray, int n, int n2) {
        if (this.q < n2) {
            throw new IllegalStateException(String.format("required=%d, qsize=%d", n2, this.q));
        }
        this.trimHead();
        System.arraycopy(this.buffer, this.p, byArray, 0, n2);
        this.p += n2;
        this.q -= n2;
    }

    public boolean ensureBuffer(int n) {
        int n2 = this.buffer.length;
        int n3 = n > 8192 ? n2 + (n / 8192 + 1) * 8192 : n2 + 8192;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.buffer, 0, byArray, 0, n2);
        this.buffer = byArray;
        return this.buffer.length >= n + this.q;
    }

    public void trimHead() {
        if (this.p == 0) {
            return;
        }
        int n = this.q - this.p;
        if (n < 4096 && this.buffer.length > 32768) {
            byte[] byArray = new byte[8192];
            System.arraycopy(this.buffer, this.p, byArray, 0, n);
            this.buffer = byArray;
        } else {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, this.p, byArray, 0, n);
            System.arraycopy(byArray, 0, this.buffer, 0, n);
        }
        this.p = 0;
        this.q = n;
    }
}

