/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtilities {
    private static final int BUFFER_SIZE = 8192;

    private IOUtilities() {
    }

    public static long transfer(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        return IOUtilities.transfer(new byte[8192], inputStream, outputStream, l);
    }

    public static long transfer(byte[] byArray, InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        int n = byArray.length;
        long l2 = l;
        long l3 = 0L;
        while (l2 > 0L) {
            long l4 = Math.min(l2, (long)n);
            assert (l4 <= Integer.MAX_VALUE);
            int n2 = inputStream.read(byArray, 0, (int)l4);
            assert (n2 != 0) : "Read Zero";
            if (n2 < 0) break;
            outputStream.write(byArray, 0, n2);
            l2 -= (long)n2;
            l3 += (long)n2;
        }
        outputStream.flush();
        return l3;
    }

    public static long transferAll(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = 0L;
        byte[] byArray = new byte[8192];
        while (true) {
            int n;
            if ((n = inputStream.read(byArray, 0, 8192)) == 0) {
                throw new IllegalStateException("illegal state");
            }
            assert (n != 0) : "Read Zero";
            if (n <= 0) break;
            try {
                outputStream.write(byArray, 0, n);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
            l += (long)n;
        }
        outputStream.flush();
        return l;
    }

    public static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        int n5 = n;
        for (int i = n2; i > 0; i -= n3) {
            n3 = inputStream.read(byArray, n5, i);
            assert (n3 != 0) : "Read Zero";
            if (n3 <= 0) break;
            n4 += n3;
            n5 += n3;
        }
        return n4;
    }

    public static int readAll(InputStream inputStream, byte[] byArray) throws IOException {
        return IOUtilities.read(inputStream, byArray, 0, byArray.length);
    }
}

