/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.time;

import java.util.Calendar;
import java.util.Date;
import jp.sfjp.armadillo.time.TimeConverter;

public final class FTime
implements TimeConverter {
    @Override
    public int int32From(long l) {
        long l2 = FTime.convert(l);
        if (l2 > Integer.MAX_VALUE || l2 < 0L) {
            String string = String.format("%d(%s) is out of the range", l, new Date(l));
            throw new IllegalArgumentException(string);
        }
        return (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public long int64From(long l) {
        return FTime.convert(l);
    }

    private static long convert(long l) {
        if (l < 315500400000L) {
            return 0x210000L;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        return calendar.get(1) - 1980 << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) / 2;
    }

    public long toMillisecond(int n, int n2) {
        int n3 = n << 16 | n2 & 0xFFFF;
        return this.toMilliseconds(n3);
    }

    @Override
    public long toMilliseconds(long l) {
        int n = (int)l;
        int n2 = n >>> 25 & 0x7F;
        int n3 = n >>> 21 & 0xF;
        int n4 = n >>> 16 & 0x1F;
        int n5 = n >>> 11 & 0x1F;
        int n6 = n >>> 5 & 0x3F;
        int n7 = (n & 0x1F) * 2;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(0L);
        calendar.set(1980 + n2, n3 - 1, n4, n5, n6, n7);
        return calendar.getTimeInMillis();
    }
}

