package jp.sfjp.armadillo;

public abstract class ProgressNotifier {

    public static final ProgressNotifier NullObject = new ProgressNotifier(1L) {
        @Override
        public void progressNotified(long part, long total) {
            // do nothing
        }
    };

    private final long total;
    private long part;

    protected ProgressNotifier(long total) {
        assert total > 0;
        this.total = total;
    }

    protected final int getRateAsIntPercent() {
        if (part < 0)
            return 0;
        if (part >= total)
            return 100;
        return (int)(100.0f / total * part);
    }

    protected final int getRateAsIntPermill() {
        if (part < 0)
            return 0;
        if (part >= total)
            return 1000;
        return (int)(1000.0f / total * part);
    }

    protected final double getRate() {
        if (part < 0)
            return 0.0f;
        if (part >= total)
            return 1.0f;
        final long rate = part / total;
        assert rate >= 0 && rate <= 1.0;
        return rate;
    }

    public final void notifyFinished() {
        part = total;
        progressNotified(part, total);
    }

    public final void notifyProgress(long increasement) {
        this.part += increasement;
        progressNotified(part, total);
    }

    public abstract void progressNotified(long part, long total);

}
