package jp.sfjp.armadillo.archive.cab;

import java.io.*;
import java.util.zip.*;

public final class CabCfData extends FilterOutputStream {

    ByteArrayOutputStream bos = new ByteArrayOutputStream();
    OutputStream os; // front
    private Deflater deflater;

    int uncompsize = 0;
    boolean finished;
    private final CabCompressionType type;

    public CabCfData(CabCompressionType type) {
        super(null);
        this.os = bos;
        this.type = type;
        switch (type) {
            case No:
                os = bos;
                break;
            case MSZIP:
                bos.write('C');
                bos.write('K');
                this.deflater = new Deflater(Deflater.BEST_COMPRESSION, true);
                deflater.reset();
                os = new DeflaterOutputStream(bos, deflater);
                break;
            case Quantum:
            case LZX:
            case Unknown:
                throw new UnsupportedOperationException("comptype: " + type);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (finished)
            throw new IOException("stream closed");
        os.write(b);
        ++uncompsize;
    }

    @Override
    public void close() throws IOException {
        finish();
    }

    public void finish() throws IOException {
        if (finished)
            return;
        switch (type) {
            case MSZIP:
                if (os instanceof DeflaterOutputStream) {
                    DeflaterOutputStream dos = (DeflaterOutputStream)os;
                    dos.finish();
                    dos.flush();
                }
                break;
            case No:
                os.flush();
                break;
            default:
                // do nothing
        }
        os = bos;
        finished = true;
    }

    public void writeInto(OutputStream out) throws IOException {
        if (!finished)
            throw new IOException("stream is not closed yet");
        bos.writeTo(out);
    }

}
