package jp.sfjp.armadillo.archive.cab;

import jp.sfjp.armadillo.archive.*;

public abstract class CabEntry extends ArchiveEntry {

    protected CabEntry() {
        super(false);
    }

    protected CabEntry(String name) {
        super(false);
        setName(name);
    }

    public CabEntry(byte[] name) {
        super(false);
        setName(name);
    }

    public static CabEntry getInstance(String name) {
        CabEntry entry = normalizePath(name).endsWith("/") ? new CabCfFolder() : new CabCfFile();
        entry.setName(name);
        return entry;
    }

    static String normalizePath(String path) {
        String s = path.replace('\\', '/');
        return s;
    }

}
