package jp.sfjp.armadillo.archive.lzh;

import java.io.*;
import jp.sfjp.armadillo.archive.*;
import jp.sfjp.armadillo.compression.lzhuf.*;

public final class LzhInputStream extends ArchiveInputStream {

    private LzhHeader header;
    private LzhEntry nextEntry;

    public LzhInputStream(InputStream is) {
        super(is);
        this.header = new LzhHeader();
    }

    public LzhEntry getNextEntry() throws IOException {
        ensureOpen();
        if (remaining > 0)
            closeEntry();
        LzhEntry entry = header.read(in);
        if (entry == null)
            return null;
        LzhMethod method = new LzhMethod(entry.method);
        if (method.isCompressing())
            frontStream = new LzssInputStream(new LzhHuffmanDecoder(in, entry.compressedSize),
                                              method.getDictionarySize(),
                                              method.getMatchSize(),
                                              method.getThreshold());
        else
            frontStream = in;
        remaining = entry.size;
        nextEntry = entry;
        return entry;
    }

    public void closeEntry() throws IOException {
        ensureOpen();
        if (nextEntry != null && remaining == nextEntry.size) {
            frontStream = in;
            remaining = nextEntry.compressedSize;
        }
        while (remaining > 0)
            skip(remaining);
        assert remaining == 0 : "rest=" + remaining;
        nextEntry = null;
        frontStream = in;
    }

    @Override
    public void close() throws IOException {
        header = null;
        super.close();
    }

}
