package jp.sfjp.armadillo.archive.zip;

import java.io.*;
import jp.sfjp.armadillo.archive.*;
import jp.sfjp.armadillo.io.*;

public final class ZipArchiveExtractor implements ArchiveExtractor {

    private ZipInputStream is;

    public ZipArchiveExtractor(InputStream is) {
        this.is = new ZipInputStream(is);
    }

    @Override
    public ArchiveEntry nextEntry() throws IOException {
        return ArchiveEntry.orNull(is.getNextEntry());
    }

    @Override
    public long extract(OutputStream os) throws IOException {
        return IOUtilities.transferAll(is, os);
    }

    @Override
    public void close() throws IOException {
        is.close();
    }

}
