package jp.sfjp.armadillo.io;

import java.io.*;

public final class VolumetricOutputStream extends FilterOutputStream {

    private long size;

    public VolumetricOutputStream() {
        super(null);
        this.size = 0;
    }

    public long getSize() {
        return size;
    }

    @Override
    public void write(int b) throws IOException {
        ++size;
    }

    @Override
    public void write(byte[] b) throws IOException {
        size += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        assert b != null && b.length >= len - off : "arguments are inconsistent";
        size += len;
    }

    @Override
    public void flush() throws IOException {
        // empty
    }

    @Override
    public void close() throws IOException {
        // empty
    }

}
