<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_chl.inc.php";

if (!empty($_REQUEST['group_id'])) { // page under group section
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_channels'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $_REQUEST['group_id']."&".SID);
		exit;
	}
}


//SETUP RSP ---------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['channel']);
$rsp->user_id = $me['user_id'];

if($c_node['rsp']['node']['auto_publish'] == 1) {
	$rsp->status_id = $c_node['rsp']['status']['live'];
}
else {
	$rsp->status_id = $c_node['rsp']['status']['pending'];
}

if (isset($group_id)) {
    $rsp->group_id = $group_id;
}

//check user_id
if (!empty($frmdata['channel_id'])) {
	$editing_channel = $channel->selChannel($frmdata['channel_id']);
	if(empty($group_id)) {
		if(isset($editing_channel['user_id']) && $editing_channel['user_id'] == $me['user_id'] && empty($editing_channel['group_id'])) { // only author can edit
			$display = 'allow_edit'; // var display will not used
		} else {
			header("Location: chl_list.php?" . SID);
			exit;
		}
	} else {
		if(isset($editing_channel['group_id']) && $editing_channel['group_id'] == $group_id) { //only groupmembeer can edit
			$display = 'allow_edit';
		} else {
			header("Location: chl_list.php?group_id=". $group_id . "&" . SID);
			exit;
		}
	}
}


if (isset($frmdata['channel_insert'])) {
	$channel->user_id = $me['user_id'];
	$channel->insertChannel($frmdata);
	
	if (empty($GLOBALS['am_error_log'])) {
		$temp['item_id'] = $channel->channel_id;
		$temp['language_id'] = $channel->language_id;
		
		//delete all
		$rsp->deleteRspItem($channel->channel_id);

		//insert node rsp entry
		if (!empty($frmdata['rsp_node'])) {
			$temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
			$rsp->insertRspItem($temp);
		}
		
		if (!empty($frmdata['group_id'])) { // page under group section
			header("Location: chl_item.php?group_id=" . $frmdata['group_id'] . "&channel_id=" . $channel->channel_id . "&".SID);
			exit;
		}
		else {
			header("Location: chl_item.php?channel_id=" . $channel->channel_id . "&".SID);
			exit;
		}
	}
}
elseif (isset($frmdata['channel_save'])) {
	$channel->updateChannel($frmdata);
	
	if (empty($GLOBALS['am_error_log'])) {
		$temp['language_id'] = $channel->language_id;
		$temp['item_id'] = $frmdata['channel_id'];
		//delete all
		$rsp->deleteRspItem($frmdata['channel_id']);

		//insert node rsp entry
		if (!empty($frmdata['rsp_node'])) {
			$temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
			$rsp->insertRspItem($temp);
		}
		
		if (!empty($frmdata['group_id'])) { // page under group section
			header("Location: chl_item.php?group_id=" . $frmdata['group_id'] . "&channel_id=" . $frmdata['channel_id'] . "&".SID);
			exit;
		}
		else {
			header("Location: chl_item.php?channel_id=" . $frmdata['channel_id'] . "&".SID);
			exit;
		}
	}
}
elseif (isset($frmdata['channel_delete'])) {
	$channel->deleteChannel($frmdata['channel_id']);
	$rsp->deleteRspItem($frmdata['channel_id']);

	if (!empty($frmdata['group_id'])) { // page under group section
		header("Location: chl_list.php?group_id=" . $frmdata['group_id'] . "&".SID);
		exit;
	}
	else {
		header("Location: chl_list.php?".SID);
		exit;
	}
}


//if we get a channel ID get the channel list
if (!empty($_REQUEST['channel_id'])) {
	$output_channel = $channel->selChannel($_REQUEST['channel_id']);
	if(isset($output_channel['user_id']) && $output_channel['user_id'] == $me['user_id']) {
		$display = 'allow_edit'; // not used
	} else {
		if(isset($group_id)) {
			header("Location: chl_list.php?group_id=". $group_id . "&" . SID);
			exit;
		} else {
			header("Location: chl_list.php?" . SID);
			exit;
		}
	}
}


//RSP items
if (isset($output_channel['channel_id'])) {
	$output_channel['rsp'] = $rsp->selRspItem($output_channel['channel_id']);
}

//move vars to template
if (!empty($output_channel)) {
	$body->set('channel', $output_channel);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

$body->set('rspconfig', $c_node['rsp']);

$template_pageLink = $lang['txt_channels'];

include "inc/footer.inc.php";

?>